/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestPageFunctionCompiler {
    private static final CallExpression ADD_10_EXPRESSION = Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.ADD, (TypeSignature)BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature())), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-%s"));

    @DataProvider(name="forceYield")
    public static Object[][] forceYield() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="forceYield")
    public void testFailureDoesNotCorruptFutureResults(boolean forceYield) {
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        Supplier projectionSupplier = functionCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty());
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Page goodPage = TestPageFunctionCompiler.createLongBlockPage(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        Block goodResult = forceYield ? this.projectWithYield(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount()), 10) : this.projectWithoutYield(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount()));
        Assert.assertEquals((int)goodPage.getPositionCount(), (int)goodResult.getPositionCount());
        Page badPage = TestPageFunctionCompiler.createLongBlockPage(0L, 1L, 2L, 3L, 4L, Long.MAX_VALUE);
        try {
            if (forceYield) {
                this.projectWithYield(projection, badPage, SelectedPositions.positionsRange((int)0, (int)100), 6);
            } else {
                this.projectWithoutYield(projection, badPage, SelectedPositions.positionsRange((int)0, (int)100));
            }
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode());
        }
        goodResult = forceYield ? this.projectWithYield(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount()), 10) : this.projectWithoutYield(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount()));
        Assert.assertEquals((int)goodPage.getPositionCount(), (int)goodResult.getPositionCount());
    }

    @Test
    public void testGeneratedClassName() {
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        String planNodeId = "7";
        String stageId = "20170707_223500_67496_zguwn.2";
        String classSuffix = stageId + "_" + planNodeId;
        Supplier projectionSupplier = functionCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of(classSuffix));
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Work work = projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), TestPageFunctionCompiler.createLongBlockPage(0L), SelectedPositions.positionsRange((int)0, (int)1));
        Assert.assertTrue((boolean)work.getClass().getSimpleName().startsWith("PageProjectionWork_" + stageId.replace('.', '_') + "_" + planNodeId));
    }

    @Test
    public void testCache() {
        PageFunctionCompiler cacheCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 100);
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()));
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")));
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        PageFunctionCompiler noCacheCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
    }

    private Block projectWithYield(PageProjection projection, Page page, SelectedPositions selectedPositions, int expectedYields) {
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        Work work = projection.project(TestingConnectorSession.SESSION, yieldSignal, page, selectedPositions);
        boolean processed = false;
        for (int i = 0; i < 1000; ++i) {
            yieldSignal.setWithDelay(1L, this.executor);
            yieldSignal.forceYieldForTesting();
            if (work.process()) {
                processed = true;
                Assert.assertEquals((int)i, (int)expectedYields);
                break;
            }
            yieldSignal.reset();
        }
        if (!processed) {
            Assert.fail((String)"result is not present");
        }
        return (Block)work.getResult();
    }

    private Block projectWithoutYield(PageProjection projection, Page page, SelectedPositions selectedPositions) {
        Work work = projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), page, selectedPositions);
        Assert.assertTrue((boolean)work.process());
        return (Block)work.getResult();
    }

    private static Page createLongBlockPage(long ... values) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(values.length);
        for (long value : values) {
            BigintType.BIGINT.writeLong(builder, value);
        }
        return new Page(new Block[]{builder.build()});
    }
}

