/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.gen.VarArgsToArrayAdapterGenerator;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestVarArgsToArrayAdapterGenerator
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalarFunction(TestVarArgsSum.VAR_ARGS_SUM);
    }

    @Test
    public void testArrayElements() {
        this.assertFunction("var_args_sum()", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("var_args_sum(1)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("var_args_sum(1, 2)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("var_args_sum(null)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("var_args_sum(1, null, 2, null, 3)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("var_args_sum(1, 2, 3)", (Type)IntegerType.INTEGER, 6);
        int k = 100;
        int expectedSum = (1 + k) * k / 2;
        this.assertFunction(String.format("var_args_sum(%s)", Joiner.on((String)",").join((Iterable)IntStream.rangeClosed(1, k).boxed().collect(Collectors.toSet()))), (Type)IntegerType.INTEGER, expectedSum);
    }

    public static class TestVarArgsSum
    extends SqlScalarFunction {
        public static final TestVarArgsSum VAR_ARGS_SUM = new TestVarArgsSum();
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(TestVarArgsSum.class, (String)"varArgsSum", (Class[])new Class[]{Object.class, long[].class});
        private static final MethodHandle USER_STATE_FACTORY = Reflection.methodHandle(TestVarArgsSum.class, (String)"createState", (Class[])new Class[0]);

        private TestVarArgsSum() {
            super(new Signature("var_args_sum", FunctionKind.SCALAR, (List)ImmutableList.of(), (List)ImmutableList.of(), IntegerType.INTEGER.getTypeSignature(), (List)ImmutableList.of((Object)IntegerType.INTEGER.getTypeSignature()), true));
        }

        public boolean isHidden() {
            return false;
        }

        public boolean isDeterministic() {
            return false;
        }

        public String getDescription() {
            return "return sum of all the parameters";
        }

        public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            VarArgsToArrayAdapterGenerator.MethodHandleAndConstructor methodHandleAndConstructor = VarArgsToArrayAdapterGenerator.generateVarArgsToArrayAdapter(Long.TYPE, Long.TYPE, (int)arity, (MethodHandle)METHOD_HANDLE, (MethodHandle)USER_STATE_FACTORY);
            return new ScalarFunctionImplementation(false, Collections.nCopies(arity, ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandleAndConstructor.getMethodHandle(), Optional.of(methodHandleAndConstructor.getConstructor()), this.isDeterministic());
        }

        @UsedByGeneratedCode
        public static Object createState() {
            return null;
        }

        @UsedByGeneratedCode
        public static long varArgsSum(Object state, long[] values) {
            long sum = 0L;
            for (long value : values) {
                sum += value;
            }
            return sum;
        }
    }
}

