/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.project.InterpretedPageFilter;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInterpretedPageFilterFunction {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();

    @Test
    public void testNullLiteral() {
        TestInterpretedPageFilterFunction.assertFilter("null", false);
    }

    @Test
    public void testBooleanLiteral() {
        TestInterpretedPageFilterFunction.assertFilter("true", true);
        TestInterpretedPageFilterFunction.assertFilter("false", false);
    }

    @Test
    public void testNotExpression() {
        TestInterpretedPageFilterFunction.assertFilter("not true", false);
        TestInterpretedPageFilterFunction.assertFilter("not false", true);
        TestInterpretedPageFilterFunction.assertFilter("not null", false);
    }

    @Test
    public void testAndExpression() {
        TestInterpretedPageFilterFunction.assertFilter("true and true", true);
        TestInterpretedPageFilterFunction.assertFilter("true and false", false);
        TestInterpretedPageFilterFunction.assertFilter("true and null", false);
        TestInterpretedPageFilterFunction.assertFilter("false and true", false);
        TestInterpretedPageFilterFunction.assertFilter("false and false", false);
        TestInterpretedPageFilterFunction.assertFilter("false and null", false);
        TestInterpretedPageFilterFunction.assertFilter("null and true", false);
        TestInterpretedPageFilterFunction.assertFilter("null and false", false);
        TestInterpretedPageFilterFunction.assertFilter("null and null", false);
    }

    @Test
    public void testORExpression() {
        TestInterpretedPageFilterFunction.assertFilter("true or true", true);
        TestInterpretedPageFilterFunction.assertFilter("true or false", true);
        TestInterpretedPageFilterFunction.assertFilter("true or null", true);
        TestInterpretedPageFilterFunction.assertFilter("false or true", true);
        TestInterpretedPageFilterFunction.assertFilter("false or false", false);
        TestInterpretedPageFilterFunction.assertFilter("false or null", false);
        TestInterpretedPageFilterFunction.assertFilter("null or true", true);
        TestInterpretedPageFilterFunction.assertFilter("null or false", false);
        TestInterpretedPageFilterFunction.assertFilter("null or null", false);
    }

    @Test
    public void testIsNullExpression() {
        TestInterpretedPageFilterFunction.assertFilter("null is null", true);
        TestInterpretedPageFilterFunction.assertFilter("42 is null", false);
    }

    @Test
    public void testIsNotNullExpression() {
        TestInterpretedPageFilterFunction.assertFilter("42 is not null", true);
        TestInterpretedPageFilterFunction.assertFilter("null is not null", false);
    }

    @Test
    public void testComparisonExpression() {
        TestInterpretedPageFilterFunction.assertFilter("42 = 42", true);
        TestInterpretedPageFilterFunction.assertFilter("42 = 42.0", true);
        TestInterpretedPageFilterFunction.assertFilter("42.42 = 42.42", true);
        TestInterpretedPageFilterFunction.assertFilter("'foo' = 'foo'", true);
        TestInterpretedPageFilterFunction.assertFilter("42 = 87", false);
        TestInterpretedPageFilterFunction.assertFilter("42 = 22.2", false);
        TestInterpretedPageFilterFunction.assertFilter("42.42 = 22.2", false);
        TestInterpretedPageFilterFunction.assertFilter("'foo' = 'bar'", false);
        TestInterpretedPageFilterFunction.assertFilter("42 != 87", true);
        TestInterpretedPageFilterFunction.assertFilter("42 != 22.2", true);
        TestInterpretedPageFilterFunction.assertFilter("42.42 != 22.22", true);
        TestInterpretedPageFilterFunction.assertFilter("'foo' != 'bar'", true);
        TestInterpretedPageFilterFunction.assertFilter("42 != 42", false);
        TestInterpretedPageFilterFunction.assertFilter("42 != 42.0", false);
        TestInterpretedPageFilterFunction.assertFilter("42.42 != 42.42", false);
        TestInterpretedPageFilterFunction.assertFilter("'foo' != 'foo'", false);
        TestInterpretedPageFilterFunction.assertFilter("42 < 88", true);
        TestInterpretedPageFilterFunction.assertFilter("42 < 88.8", true);
        TestInterpretedPageFilterFunction.assertFilter("42.42 < 88.8", true);
        TestInterpretedPageFilterFunction.assertFilter("'bar' < 'foo'", true);
        TestInterpretedPageFilterFunction.assertFilter("88 < 42", false);
        TestInterpretedPageFilterFunction.assertFilter("88 < 42.42", false);
        TestInterpretedPageFilterFunction.assertFilter("88.8 < 42.42", false);
        TestInterpretedPageFilterFunction.assertFilter("'foo' < 'bar'", false);
        TestInterpretedPageFilterFunction.assertFilter("42 <= 88", true);
        TestInterpretedPageFilterFunction.assertFilter("42 <= 88.8", true);
        TestInterpretedPageFilterFunction.assertFilter("42.42 <= 88.8", true);
        TestInterpretedPageFilterFunction.assertFilter("'bar' <= 'foo'", true);
        TestInterpretedPageFilterFunction.assertFilter("42 <= 42", true);
        TestInterpretedPageFilterFunction.assertFilter("42 <= 42.0", true);
        TestInterpretedPageFilterFunction.assertFilter("42.42 <= 42.42", true);
        TestInterpretedPageFilterFunction.assertFilter("'foo' <= 'foo'", true);
        TestInterpretedPageFilterFunction.assertFilter("88 <= 42", false);
        TestInterpretedPageFilterFunction.assertFilter("88 <= 42.42", false);
        TestInterpretedPageFilterFunction.assertFilter("88.8 <= 42.42", false);
        TestInterpretedPageFilterFunction.assertFilter("'foo' <= 'bar'", false);
        TestInterpretedPageFilterFunction.assertFilter("88 >= 42", true);
        TestInterpretedPageFilterFunction.assertFilter("88.8 >= 42.0", true);
        TestInterpretedPageFilterFunction.assertFilter("88.8 >= 42.42", true);
        TestInterpretedPageFilterFunction.assertFilter("'foo' >= 'bar'", true);
        TestInterpretedPageFilterFunction.assertFilter("42 >= 88", false);
        TestInterpretedPageFilterFunction.assertFilter("42.42 >= 88.0", false);
        TestInterpretedPageFilterFunction.assertFilter("42.42 >= 88.88", false);
        TestInterpretedPageFilterFunction.assertFilter("'bar' >= 'foo'", false);
        TestInterpretedPageFilterFunction.assertFilter("88 >= 42", true);
        TestInterpretedPageFilterFunction.assertFilter("88.8 >= 42.0", true);
        TestInterpretedPageFilterFunction.assertFilter("88.8 >= 42.42", true);
        TestInterpretedPageFilterFunction.assertFilter("'foo' >= 'bar'", true);
        TestInterpretedPageFilterFunction.assertFilter("42 >= 42", true);
        TestInterpretedPageFilterFunction.assertFilter("42 >= 42.0", true);
        TestInterpretedPageFilterFunction.assertFilter("42.42 >= 42.42", true);
        TestInterpretedPageFilterFunction.assertFilter("'foo' >= 'foo'", true);
        TestInterpretedPageFilterFunction.assertFilter("42 >= 88", false);
        TestInterpretedPageFilterFunction.assertFilter("42.42 >= 88.0", false);
        TestInterpretedPageFilterFunction.assertFilter("42.42 >= 88.88", false);
        TestInterpretedPageFilterFunction.assertFilter("'bar' >= 'foo'", false);
    }

    @Test
    public void testComparisonExpressionWithNulls() {
        for (ComparisonExpression.Operator operator : ComparisonExpression.Operator.values()) {
            if (operator == ComparisonExpression.Operator.IS_DISTINCT_FROM) continue;
            TestInterpretedPageFilterFunction.assertFilter(String.format("NULL %s NULL", operator.getValue()), false);
            TestInterpretedPageFilterFunction.assertFilter(String.format("42 %s NULL", operator.getValue()), false);
            TestInterpretedPageFilterFunction.assertFilter(String.format("NULL %s 42", operator.getValue()), false);
            TestInterpretedPageFilterFunction.assertFilter(String.format("11.1 %s NULL", operator.getValue()), false);
            TestInterpretedPageFilterFunction.assertFilter(String.format("NULL %s 11.1", operator.getValue()), false);
        }
    }

    private static void assertFilter(String expression, boolean expectedValue) {
        InterpretedPageFilter filterFunction = new InterpretedPageFilter(FunctionAssertions.createExpression(expression, METADATA, TypeProvider.empty()), TypeProvider.empty(), (Map)ImmutableMap.of(), METADATA, SQL_PARSER, SessionTestUtils.TEST_SESSION);
        SelectedPositions selectedPositions = filterFunction.filter(SessionTestUtils.TEST_SESSION.toConnectorSession(), new Page(1, new Block[0]));
        Assert.assertEquals((int)selectedPositions.size(), (int)(expectedValue ? 1 : 0));
        if (expectedValue) {
            if (selectedPositions.isList()) {
                Assert.assertEquals((int)selectedPositions.getPositions()[selectedPositions.getOffset()], (int)0);
            } else {
                Assert.assertEquals((int)selectedPositions.getOffset(), (int)0);
            }
        } else {
            Assert.assertTrue((boolean)selectedPositions.isEmpty());
        }
    }
}

