/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.InterpretedPageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInterpretedPageProjectionFunction {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-%s"));

    @Test
    public void testBooleanExpression() {
        TestInterpretedPageProjectionFunction.assertProjection("true", true);
        TestInterpretedPageProjectionFunction.assertProjection("false", false);
        TestInterpretedPageProjectionFunction.assertProjection("1 = 1", true);
        TestInterpretedPageProjectionFunction.assertProjection("1 = 0", false);
        TestInterpretedPageProjectionFunction.assertProjection("true and false", false);
    }

    @Test
    public void testArithmeticExpression() {
        TestInterpretedPageProjectionFunction.assertProjection("42 + 87", 129);
        TestInterpretedPageProjectionFunction.assertProjection("42 + 22.2E0", 64.2);
        TestInterpretedPageProjectionFunction.assertProjection("11.1E0 + 22.2E0", 33.3);
        TestInterpretedPageProjectionFunction.assertProjection("42 - 87", -45);
        TestInterpretedPageProjectionFunction.assertProjection("42 - 22.2E0", 19.8);
        TestInterpretedPageProjectionFunction.assertProjection("11.1E0 - 22.2E0", -11.1);
        TestInterpretedPageProjectionFunction.assertProjection("42 * 87", 3654);
        TestInterpretedPageProjectionFunction.assertProjection("42 * 22.2E0", 932.4);
        TestInterpretedPageProjectionFunction.assertProjection("11.1E0 * 22.2E0", 246.42);
        TestInterpretedPageProjectionFunction.assertProjection("42 / 87", 0);
        TestInterpretedPageProjectionFunction.assertProjection("42 / 22.2E0", 1.8918918918918919);
        TestInterpretedPageProjectionFunction.assertProjection("11.1E0 / 22.2E0", 0.5);
        TestInterpretedPageProjectionFunction.assertProjection("42 % 87", 42);
        TestInterpretedPageProjectionFunction.assertProjection("42 % 22.2E0", 19.8);
        TestInterpretedPageProjectionFunction.assertProjection("11.1E0 % 22.2E0", 11.1);
        TestInterpretedPageProjectionFunction.assertProjection("42 + BIGINT '87'", 129L);
        TestInterpretedPageProjectionFunction.assertProjection("BIGINT '42' - 22.2E0", 19.8);
        TestInterpretedPageProjectionFunction.assertProjection("42 * BIGINT '87'", 3654L);
        TestInterpretedPageProjectionFunction.assertProjection("BIGINT '11' / 22.2E0", 0.4954954954954955);
        TestInterpretedPageProjectionFunction.assertProjection("11.1E0 % BIGINT '22'", 11.1);
    }

    @Test
    public void testArithmeticExpressionWithNulls() {
        for (ArithmeticBinaryExpression.Operator operator : ArithmeticBinaryExpression.Operator.values()) {
            TestInterpretedPageProjectionFunction.assertProjection("CAST(NULL AS INTEGER) " + operator.getValue() + " CAST(NULL AS INTEGER)", null);
            TestInterpretedPageProjectionFunction.assertProjection("42 " + operator.getValue() + " NULL", null);
            TestInterpretedPageProjectionFunction.assertProjection("NULL " + operator.getValue() + " 42", null);
            TestInterpretedPageProjectionFunction.assertProjection("11.1 " + operator.getValue() + " CAST(NULL AS INTEGER)", null);
            TestInterpretedPageProjectionFunction.assertProjection("CAST(NULL AS INTEGER) " + operator.getValue() + " 11.1", null);
        }
    }

    @Test
    public void testCoalesceExpression() {
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(42, 87, 100)", 42);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(NULL, 87, 100)", 87);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(42, NULL, 100)", 42);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(42, NULL, BIGINT '100')", 42L);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(NULL, NULL, 100)", 100);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(NULL, NULL, BIGINT '100')", 100L);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(42.2E0, 87.2E0, 100.2E0)", 42.2);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(NULL, 87.2E0, 100.2E0)", 87.2);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(42.2E0, NULL, 100.2E0)", 42.2);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(NULL, NULL, 100.2E0)", 100.2);
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE('foo', 'bar', 'zah')", "foo");
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(NULL, 'bar', 'zah')", "bar");
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE('foo', NULL, 'zah')", "foo");
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(NULL, NULL, 'zah')", "zah");
        TestInterpretedPageProjectionFunction.assertProjection("COALESCE(NULL, NULL, NULL)", null);
    }

    @Test
    public void testNullIf() {
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(42, 42)", null);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(42, 42.0E0)", null);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(42.42E0, 42.42E0)", null);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF('foo', 'foo')", null);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(42, 87)", 42);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(42, 22.2E0)", 42);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(42, BIGINT '87')", 42);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(BIGINT '42', 22.2E0)", 42L);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(42.42E0, 22.2E0)", 42.42);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF('foo', 'bar')", "foo");
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(NULL, NULL)", null);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(42, NULL)", 42);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(NULL, 42)", null);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(11.1E0, NULL)", 11.1);
        TestInterpretedPageProjectionFunction.assertProjection("NULLIF(NULL, 11.1E0)", null);
    }

    @Test
    public void testSymbolReference() {
        Symbol symbol = new Symbol("symbol");
        ImmutableMap symbolToInputMappings = ImmutableMap.of((Object)symbol, (Object)0);
        TestInterpretedPageProjectionFunction.assertProjection("symbol", true, (Map<Symbol, Integer>)symbolToInputMappings, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)BooleanType.BOOLEAN)), 0, TestInterpretedPageProjectionFunction.createBlock((Type)BooleanType.BOOLEAN, true));
        TestInterpretedPageProjectionFunction.assertProjection("symbol", null, (Map<Symbol, Integer>)symbolToInputMappings, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)BooleanType.BOOLEAN)), 0, TestInterpretedPageProjectionFunction.createNullBlock((Type)BooleanType.BOOLEAN));
        TestInterpretedPageProjectionFunction.assertProjection("symbol", 42L, (Map<Symbol, Integer>)symbolToInputMappings, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)BigintType.BIGINT)), 0, TestInterpretedPageProjectionFunction.createBlock((Type)BigintType.BIGINT, 42));
        TestInterpretedPageProjectionFunction.assertProjection("symbol", null, (Map<Symbol, Integer>)symbolToInputMappings, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)BigintType.BIGINT)), 0, TestInterpretedPageProjectionFunction.createNullBlock((Type)BigintType.BIGINT));
        TestInterpretedPageProjectionFunction.assertProjection("symbol", 11.1, (Map<Symbol, Integer>)symbolToInputMappings, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)DoubleType.DOUBLE)), 0, TestInterpretedPageProjectionFunction.createBlock((Type)DoubleType.DOUBLE, 11.1));
        TestInterpretedPageProjectionFunction.assertProjection("symbol", null, (Map<Symbol, Integer>)symbolToInputMappings, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)DoubleType.DOUBLE)), 0, TestInterpretedPageProjectionFunction.createNullBlock((Type)DoubleType.DOUBLE));
        TestInterpretedPageProjectionFunction.assertProjection("symbol", "foo", (Map<Symbol, Integer>)symbolToInputMappings, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR)), 0, TestInterpretedPageProjectionFunction.createBlock((Type)VarcharType.VARCHAR, "foo"));
        TestInterpretedPageProjectionFunction.assertProjection("symbol", null, (Map<Symbol, Integer>)symbolToInputMappings, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR)), 0, TestInterpretedPageProjectionFunction.createNullBlock((Type)VarcharType.VARCHAR));
    }

    private static void assertProjection(String expression, @Nullable Object expectedValue) {
        TestInterpretedPageProjectionFunction.assertProjection(expression, expectedValue, (Map<Symbol, Integer>)ImmutableMap.of(), TypeProvider.empty(), 0, new Block[0]);
    }

    private static void assertProjection(String expression, @Nullable Object expectedValue, Map<Symbol, Integer> symbolToInputMappings, TypeProvider symbolTypes, int position, Block ... blocks) {
        TestInterpretedPageProjectionFunction.assertProjection(expression, new Object[]{expectedValue}, symbolToInputMappings, symbolTypes, new int[]{position}, blocks);
    }

    private static void assertProjection(String expression, Object[] expectedValues, Map<Symbol, Integer> symbolToInputMappings, TypeProvider symbolTypes, int[] positions, Block ... blocks) {
        int i;
        InterpretedPageProjection projectionFunction = new InterpretedPageProjection(FunctionAssertions.createExpression(expression, METADATA, symbolTypes), symbolTypes, symbolToInputMappings, METADATA, SQL_PARSER, SessionTestUtils.TEST_SESSION);
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        Work work = projectionFunction.project(SessionTestUtils.TEST_SESSION.toConnectorSession(), yieldSignal, new Page(positions.length, blocks), SelectedPositions.positionsList((int[])positions, (int)0, (int)positions.length));
        for (int i2 = 0; i2 < positions.length; ++i2) {
            yieldSignal.setWithDelay(1L, executor);
            yieldSignal.forceYieldForTesting();
            Assert.assertFalse((boolean)work.process());
            yieldSignal.reset();
        }
        yieldSignal.setWithDelay(1L, executor);
        yieldSignal.forceYieldForTesting();
        yieldSignal.reset();
        Assert.assertTrue((boolean)work.process());
        Block block = (Block)work.getResult();
        List<Object> actualValues = BlockAssertions.toValues(projectionFunction.getType(), block);
        Assert.assertEquals((int)actualValues.size(), (int)positions.length);
        Assert.assertEquals((int)expectedValues.length, (int)positions.length);
        for (i = 0; i < positions.length; ++i) {
            Assert.assertEquals((Object)actualValues.get(i), (Object)expectedValues[i]);
        }
        work = projectionFunction.project(SessionTestUtils.TEST_SESSION.toConnectorSession(), new DriverYieldSignal(), new Page(positions.length, blocks), SelectedPositions.positionsList((int[])positions, (int)0, (int)positions.length));
        Assert.assertTrue((boolean)work.process());
        block = (Block)work.getResult();
        actualValues = BlockAssertions.toValues(projectionFunction.getType(), block);
        Assert.assertEquals((int)actualValues.size(), (int)positions.length);
        Assert.assertEquals((int)expectedValues.length, (int)positions.length);
        for (i = 0; i < positions.length; ++i) {
            Assert.assertEquals((Object)actualValues.get(i), (Object)expectedValues[i]);
        }
    }

    private static Block createBlock(Type type, Object value) {
        return TestInterpretedPageProjectionFunction.createBlock(type, new Object[]{value});
    }

    private static Block createNullBlock(Type type) {
        return TestInterpretedPageProjectionFunction.createBlock(type, new Object[]{null});
    }

    private static Block createBlock(Type type, Object[] values) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, values.length);
        for (Object value : values) {
            TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)value);
        }
        return blockBuilder.build();
    }
}

