/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.optimizations.AddLocalExchanges;
import com.facebook.presto.sql.planner.optimizations.CheckSubqueryNodesAreRewritten;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.tests.QueryTemplate;
import com.facebook.presto.util.MorePredicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLogicalPlanner
extends BasePlanTest {
    @Test
    public void testAggregation() {
        this.assertDistributedPlan("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice")))))))));
        this.assertDistributedPlan("SELECT orderstatus, sum(totalprice) FROM orders WHERE orderstatus='O' GROUP BY orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice")))))))));
    }

    @Test
    public void testDistinctLimitOverInequalityJoin() {
        this.assertPlan("SELECT DISTINCT o.orderkey FROM orders o JOIN lineitem l ON o.orderkey < l.orderkey LIMIT 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY < L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")), PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))).withExactOutputs((List<String>)ImmutableList.of((Object)"O_ORDERKEY", (Object)"L_ORDERKEY")))))));
        this.assertPlan("SELECT DISTINCT o.orderkey FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey LIMIT 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_SHIPPRIORITY", "L_LINENUMBER")), Optional.of("O_ORDERKEY < L_ORDERKEY"), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey")))).withExactOutputs((List<String>)ImmutableList.of((Object)"O_ORDERKEY"))))));
    }

    @Test
    public void testDistinctOverConstants() {
        this.assertPlan("SELECT count(*), count(distinct orderkey) FROM (SELECT * FROM orders WHERE orderkey = 1)", PlanMatchPattern.anyTree(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"orderkey"), "hash", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', coalesce(\"$operator$hash_code\"(orderkey), 0))")), PlanMatchPattern.filter("orderkey = BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))))));
    }

    @Test
    public void testInnerInequalityJoinNoEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.orderkey < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY < L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")), PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testInnerInequalityJoinWithEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_SHIPPRIORITY", "L_LINENUMBER")), Optional.of("O_ORDERKEY < L_ORDERKEY"), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testLeftConvertedToInnerInequalityJoinNoEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o LEFT JOIN lineitem l ON o.orderkey < l.orderkey WHERE l.orderkey IS NOT NULL", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY < L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")), PlanMatchPattern.any(PlanMatchPattern.filter("NOT (L_ORDERKEY IS NULL)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testJoinWithOrderBySameKey() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey ORDER BY l.orderkey ASC, o.orderkey ASC", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testUncorrelatedSubqueries() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey = (SELECT orderkey FROM lineitem ORDER BY orderkey LIMIT 1)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("X", "Y")), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.project(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey NOT IN (SELECT orderkey FROM lineitem WHERE linenumber < 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testPushDownJoinConditionConjunctsToInnerSideBasedOnInheritedPredicate() {
        ImmutableMap tableScanConstraint = ImmutableMap.builder().put((Object)"name", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"blah"))).build();
        this.assertPlan("SELECT nationkey FROM nation LEFT OUTER JOIN region ON nation.regionkey = region.regionkey and nation.name = region.name WHERE nation.name = 'blah'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("NATION_NAME", "REGION_NAME"), PlanMatchPattern.equiJoinClause("NATION_REGIONKEY", "REGION_REGIONKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.constrainedTableScan("nation", (Map<String, Domain>)tableScanConstraint, (Map<String, String>)ImmutableMap.of((Object)"NATION_NAME", (Object)"name", (Object)"NATION_REGIONKEY", (Object)"regionkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.constrainedTableScan("region", (Map<String, Domain>)tableScanConstraint, (Map<String, String>)ImmutableMap.of((Object)"REGION_NAME", (Object)"name", (Object)"REGION_REGIONKEY", (Object)"regionkey"))))));
    }

    @Test
    public void testSameScalarSubqueryIsAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders WHERE CAST(orderkey AS INTEGER) = (SELECT 1) AND custkey = (SELECT 2) AND CAST(custkey as REAL) != (SELECT 1)"), EnforceSingleRowNode.class::isInstance), (int)2);
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey = (SELECT 1) AND o2.orderkey = (SELECT 1) AND o1.orderkey + o2.orderkey = (SELECT 1)"), EnforceSingleRowNode.class::isInstance), (int)1);
    }

    @Test
    public void testSameInSubqueryIsAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey IN (SELECT 1) AND (o1.orderkey IN (SELECT 1) OR o1.orderkey IN (SELECT 1))"), SemiJoinNode.class::isInstance), (int)1);
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT 1 IN (SELECT 1), 2 IN (SELECT 1) WHERE 1 IN (SELECT 1)"), SemiJoinNode.class::isInstance), (int)2);
    }

    @Test
    public void testSameQualifiedSubqueryIsAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey <= ALL(SELECT 1) AND (o1.orderkey <= ALL(SELECT 1) OR o1.orderkey <= ALL(SELECT 1))"), AggregationNode.class::isInstance), (int)1);
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT 1 <= ALL(SELECT 1), 2 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)"), AggregationNode.class::isInstance), (int)2);
    }

    private static int countOfMatchingNodes(Plan plan, Predicate<PlanNode> predicate) {
        return PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(predicate).count();
    }

    @Test
    public void testRemoveUnreferencedScalarInputApplyNodes() {
        this.assertPlanContainsNoApplyOrAnyJoin("SELECT (SELECT 1)");
    }

    @Test
    public void testSubqueryPruning() {
        List<QueryTemplate.Parameter> subqueries = QueryTemplate.parameter("subquery").of("orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)", "EXISTS(SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)", "0 = (SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)");
        QueryTemplate.queryTemplate("SELECT COUNT(*) FROM (SELECT %subquery% FROM orders)", new QueryTemplate.Parameter[0]).replaceAll(subqueries).forEach(this::assertPlanContainsNoApplyOrAnyJoin);
    }

    @Test
    public void testJoinOutputPruning() {
        this.assertPlan("SELECT nationkey FROM nation JOIN region ON nation.regionkey = region.regionkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("REGIONKEY_LEFT", "REGIONKEY_RIGHT")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY_LEFT", (Object)"regionkey", (Object)"NATIONKEY", (Object)"nationkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY_RIGHT", (Object)"regionkey"))))).withNumberOfOutputColumns(1).withOutputs((List<String>)ImmutableList.of((Object)"NATIONKEY")));
    }

    private void assertPlanContainsNoApplyOrAnyJoin(String sql) {
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(sql, LogicalPlanner.Stage.OPTIMIZED).getRoot()).where(MorePredicates.isInstanceOfAny((Class[])new Class[]{ApplyNode.class, JoinNode.class, IndexJoinNode.class, SemiJoinNode.class, LateralJoinNode.class})).matches(), (String)("Unexpected node for query: " + sql));
    }

    @Test
    public void testCorrelatedSubqueries() {
        this.assertPlan("SELECT orderkey FROM orders WHERE 3 = (SELECT orderkey)", LogicalPlanner.Stage.OPTIMIZED, PlanMatchPattern.any(PlanMatchPattern.filter("X = BIGINT '3'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))));
    }

    @Test
    public void testCorrelatedScalarSubqueryInSelect() {
        this.assertDistributedPlan("SELECT name, (SELECT name FROM region WHERE regionkey = nation.regionkey) FROM nation", PlanMatchPattern.anyTree(PlanMatchPattern.filter(String.format("CASE \"is_distinct\" WHEN true THEN true ELSE CAST(fail(%s, 'Scalar sub-query has returned multiple rows') AS boolean) END", StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode()), PlanMatchPattern.project(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"unique"), "hash", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', coalesce(\"$operator$hash_code\"(unique), 0))")), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("n_regionkey", "r_regionkey")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_regionkey", (Object)"regionkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_regionkey", (Object)"regionkey"))))))))));
    }

    @Test
    public void testStreamingAggregationForCorrelatedSubquery() {
        this.assertDistributedPlan("SELECT name, (SELECT max(name) FROM region WHERE regionkey = nation.regionkey AND length(name) > length(nation.name)) FROM nation", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("n_name", "n_regionkey", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"r_name"))), (List<String>)ImmutableList.of((Object)"n_name", (Object)"n_regionkey", (Object)"unique"), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_name", (Object)"name", (Object)"n_regionkey", (Object)"regionkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_name", (Object)"name")))))));
        this.assertDistributedPlan("SELECT name, (SELECT max(name) FROM region WHERE regionkey > nation.regionkey) FROM nation", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("n_name", "n_regionkey", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"r_name"))), (List<String>)ImmutableList.of((Object)"n_name", (Object)"n_regionkey", (Object)"unique"), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_name", (Object)"name", (Object)"n_regionkey", (Object)"regionkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_name", (Object)"name")))))));
    }

    @Test
    public void testStreamingAggregationOverJoin() {
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o, lineitem l WHERE o.orderkey=l.orderkey GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"o_orderkey"), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("o_orderkey", "l_orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey")))))));
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o LEFT JOIN lineitem l ON o.orderkey=l.orderkey GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"o_orderkey"), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("o_orderkey", "l_orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey")))))));
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o, lineitem l GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("orderkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testCorrelatedInUncorrelatedFiltersPushDown() {
        this.assertPlan("SELECT orderkey, comment IN (SELECT clerk FROM orders s WHERE s.orderkey = o.orderkey AND s.orderkey < 7) FROM lineitem o", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey < BIGINT '7'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))))));
    }

    @Test
    public void testSymbolsPrunedInCorrelatedInPredicateSource() {
        this.assertPlan("SELECT orderkey, comment IN (SELECT clerk FROM orders s WHERE s.orderkey = o.orderkey AND s.orderkey < 7) FROM lineitem o", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"comment", (Object)"comment"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testDoubleNestedCorrelatedSubqueries() {
        this.assertPlan("SELECT orderkey FROM orders o WHERE 3 IN (SELECT o.custkey FROM lineitem l WHERE (SELECT l.orderkey = o.orderkey))", LogicalPlanner.Stage.OPTIMIZED, PlanMatchPattern.anyTree(PlanMatchPattern.filter("OUTER_FILTER", PlanMatchPattern.apply((List<String>)ImmutableList.of((Object)"C", (Object)"O"), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"OUTER_FILTER", (Object)PlanMatchPattern.expression("THREE IN (C)")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"THREE", (Object)PlanMatchPattern.expression("BIGINT '3'")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O", (Object)"orderkey", (Object)"C", (Object)"custkey"))), PlanMatchPattern.project(PlanMatchPattern.any(PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L", (Object)"orderkey")))))))), MorePredicates.isInstanceOfAny((Class[])new Class[]{AddLocalExchanges.class, CheckSubqueryNodesAreRewritten.class}).negate());
    }

    @Test
    public void testCorrelatedScalarAggregationRewriteToLeftOuterJoin() {
        this.assertPlan("SELECT orderkey FROM orders WHERE EXISTS(SELECT 1 WHERE orderkey = 3)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("FINAL_COUNT > BIGINT '0'", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"FINAL_COUNT", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"NON_NULL"))), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("BIGINT '3' = ORDERKEY"), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"NON_NULL", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))))));
    }

    @Test
    public void testRemovesTrivialFilters() {
        this.assertPlan("SELECT * FROM nation WHERE 1 = 1", PlanMatchPattern.output(PlanMatchPattern.tableScan("nation")));
        this.assertPlan("SELECT * FROM nation WHERE 1 = 0", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
    }

    @Test
    public void testPruneCountAggregationOverScalar() {
        this.assertPlan("SELECT count(*) FROM (SELECT sum(orderkey) FROM orders)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"_col0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"))))));
        this.assertPlan("SELECT count(s) FROM (SELECT sum(orderkey) AS s FROM orders)", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")));
        this.assertPlan("SELECT count(*) FROM (SELECT sum(orderkey) FROM orders GROUP BY custkey)", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")));
    }

    @Test
    public void testPickTableLayoutWithFilter() {
        ImmutableMap filterConstraint = ImmutableMap.builder().put((Object)"orderkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L)).build();
        this.assertPlan("SELECT orderkey FROM orders WHERE orderkey=5", PlanMatchPattern.output(PlanMatchPattern.filter("orderkey = BIGINT '5'", PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)filterConstraint, (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
    }

    @Test
    public void testBroadcastCorrelatedSubqueryAvoidsRemoteExchangeBeforeAggregation() {
        Session broadcastJoin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("force_single_node_output", Boolean.toString(false)).build();
        PlanMatchPattern joinBuildSideWithRemoteExchange = PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
        Consumer<Plan> validateSingleRemoteExchange = plan -> Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE), (int)1);
        Consumer<Plan> validateSingleStreamingAggregation = plan -> Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof AggregationNode && ((AggregationNode)node).getGroupingKeys().contains(new Symbol("unique")) && ((AggregationNode)node).isStreamable()), (int)1);
        this.assertPlanWithSession("SELECT (SELECT count(*) FROM region r2 WHERE r2.regionkey > r1.regionkey) FROM region r1", broadcastJoin, false, joinBuildSideWithRemoteExchange, validateSingleRemoteExchange.andThen(validateSingleStreamingAggregation));
        this.assertPlanWithSession("SELECT count(count) FROM (SELECT o1.orderkey orderkey, (SELECT count(*) FROM orders o2 WHERE o2.orderkey > o1.orderkey) count FROM orders o1) GROUP BY orderkey", broadcastJoin, false, joinBuildSideWithRemoteExchange, validateSingleRemoteExchange.andThen(validateSingleStreamingAggregation));
    }

    @Test
    public void testUsesDistributedJoinIfNaturallyPartitionedOnProbeSymbols() {
        Session broadcastJoin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("force_single_node_output", Boolean.toString(false)).setSystemProperty("optimize_hash_generation", Boolean.toString(false)).build();
        this.assertPlanWithSession("SELECT r1.regionkey FROM (SELECT regionkey FROM region GROUP BY regionkey) r1, region r2 WHERE r2.regionkey = r1.regionkey", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LEFT_REGIONKEY", "RIGHT_REGIONKEY")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"LEFT_REGIONKEY", (Object)"regionkey")))))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"RIGHT_REGIONKEY", (Object)"regionkey")))))), plan -> Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE), (int)2));
        this.assertPlanWithSession("SELECT * FROM (SELECT * FROM (VALUES 1) t(a)) t, region r WHERE r.regionkey = t.a", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
        this.assertPlanWithSession("SELECT * FROM (SELECT regionkey FROM region GROUP BY regionkey) r1, region r2 WHERE r2.regionkey > r1.regionkey", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testDistributedSort() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.DESCENDING, SortItem.NullOrdering.LAST));
        this.assertDistributedPlan("SELECT orderkey FROM orders ORDER BY orderkey DESC", PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))))));
        this.assertDistributedPlan("SELECT orderkey FROM orders ORDER BY orderkey DESC", Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("distributed_sort", Boolean.toString(false)).build(), PlanMatchPattern.output(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))))));
    }
}

