/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.TypeValidator;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.testing.TestingMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTypeValidator {
    private static final TableHandle TEST_TABLE_HANDLE = new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle());
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final TypeValidator TYPE_VALIDATOR = new TypeValidator();
    private SymbolAllocator symbolAllocator;
    private TableScanNode baseTableScan;
    private Symbol columnA;
    private Symbol columnB;
    private Symbol columnC;
    private Symbol columnD;
    private Symbol columnE;

    @BeforeMethod
    public void setUp() {
        this.symbolAllocator = new SymbolAllocator();
        this.columnA = this.symbolAllocator.newSymbol("a", (Type)BigintType.BIGINT);
        this.columnB = this.symbolAllocator.newSymbol("b", (Type)IntegerType.INTEGER);
        this.columnC = this.symbolAllocator.newSymbol("c", (Type)DoubleType.DOUBLE);
        this.columnD = this.symbolAllocator.newSymbol("d", (Type)DateType.DATE);
        this.columnE = this.symbolAllocator.newSymbol("e", (Type)VarcharType.createVarcharType((int)3));
        ImmutableMap assignments = ImmutableMap.builder().put((Object)this.columnA, (Object)new TestingMetadata.TestingColumnHandle("a")).put((Object)this.columnB, (Object)new TestingMetadata.TestingColumnHandle("b")).put((Object)this.columnC, (Object)new TestingMetadata.TestingColumnHandle("c")).put((Object)this.columnD, (Object)new TestingMetadata.TestingColumnHandle("d")).put((Object)this.columnE, (Object)new TestingMetadata.TestingColumnHandle("e")).build();
        this.baseTableScan = new TableScanNode(TestTypeValidator.newId(), TEST_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments, Optional.empty(), TupleDomain.all());
    }

    @Test
    public void testValidProject() {
        Cast expression1 = new Cast((Expression)this.columnB.toSymbolReference(), "bigint");
        Cast expression2 = new Cast((Expression)this.columnC.toSymbolReference(), "bigint");
        Assignments assignments = Assignments.builder().put(this.symbolAllocator.newSymbol((Expression)expression1, (Type)BigintType.BIGINT), (Expression)expression1).put(this.symbolAllocator.newSymbol((Expression)expression2, (Type)BigintType.BIGINT), (Expression)expression2).build();
        ProjectNode node = new ProjectNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, assignments);
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidUnion() {
        Symbol outputSymbol = this.symbolAllocator.newSymbol("output", (Type)DateType.DATE);
        ImmutableListMultimap mappings = ImmutableListMultimap.builder().put((Object)outputSymbol, (Object)this.columnD).put((Object)outputSymbol, (Object)this.columnD).build();
        UnionNode node = new UnionNode(TestTypeValidator.newId(), (List)ImmutableList.of((Object)this.baseTableScan, (Object)this.baseTableScan), (ListMultimap)mappings, (List)ImmutableList.copyOf((Collection)mappings.keySet()));
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidWindow() {
        Symbol windowSymbol = this.symbolAllocator.newSymbol("sum", (Type)DoubleType.DOUBLE);
        Signature signature = new Signature("sum", FunctionKind.WINDOW, (List)ImmutableList.of(), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false);
        FunctionCall functionCall = new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)this.columnC.toSymbolReference()));
        WindowNode.Frame frame = new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty());
        WindowNode.Function function = new WindowNode.Function(functionCall, signature, frame);
        WindowNode.Specification specification = new WindowNode.Specification((List)ImmutableList.of(), Optional.empty());
        WindowNode node = new WindowNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, specification, (Map)ImmutableMap.of((Object)windowSymbol, (Object)function), Optional.empty(), (Set)ImmutableSet.of(), 0);
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidAggregation() {
        Symbol aggregationSymbol = this.symbolAllocator.newSymbol("sum", (Type)DoubleType.DOUBLE);
        AggregationNode node = new AggregationNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationSymbol, (Object)new AggregationNode.Aggregation(new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)this.columnC.toSymbolReference())), new Signature("sum", FunctionKind.AGGREGATE, (List)ImmutableList.of(), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false), Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)this.columnA, (Object)this.columnB)), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidTypeOnlyCoercion() {
        Cast expression = new Cast((Expression)this.columnB.toSymbolReference(), "bigint");
        Assignments assignments = Assignments.builder().put(this.symbolAllocator.newSymbol((Expression)expression, (Type)BigintType.BIGINT), (Expression)expression).put(this.symbolAllocator.newSymbol((Expression)this.columnE.toSymbolReference(), (Type)VarcharType.VARCHAR), (Expression)this.columnE.toSymbolReference()).build();
        ProjectNode node = new ProjectNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, assignments);
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of symbol 'expr(_[0-9]+)?' is expected to be bigint, but the actual type is integer")
    public void testInvalidProject() {
        Cast expression1 = new Cast((Expression)this.columnB.toSymbolReference(), "integer");
        Cast expression2 = new Cast((Expression)this.columnA.toSymbolReference(), "integer");
        Assignments assignments = Assignments.builder().put(this.symbolAllocator.newSymbol((Expression)expression1, (Type)BigintType.BIGINT), (Expression)expression1).put(this.symbolAllocator.newSymbol((Expression)expression1, (Type)IntegerType.INTEGER), (Expression)expression2).build();
        ProjectNode node = new ProjectNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, assignments);
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of symbol 'sum(_[0-9]+)?' is expected to be double, but the actual type is bigint")
    public void testInvalidAggregationFunctionCall() {
        Symbol aggregationSymbol = this.symbolAllocator.newSymbol("sum", (Type)DoubleType.DOUBLE);
        AggregationNode node = new AggregationNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationSymbol, (Object)new AggregationNode.Aggregation(new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)this.columnA.toSymbolReference())), new Signature("sum", FunctionKind.AGGREGATE, (List)ImmutableList.of(), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false), Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)this.columnA, (Object)this.columnB)), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of symbol 'sum(_[0-9]+)?' is expected to be double, but the actual type is bigint")
    public void testInvalidAggregationFunctionSignature() {
        Symbol aggregationSymbol = this.symbolAllocator.newSymbol("sum", (Type)DoubleType.DOUBLE);
        AggregationNode node = new AggregationNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationSymbol, (Object)new AggregationNode.Aggregation(new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)this.columnC.toSymbolReference())), new Signature("sum", FunctionKind.AGGREGATE, (List)ImmutableList.of(), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false), Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)this.columnA, (Object)this.columnB)), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of symbol 'sum(_[0-9]+)?' is expected to be double, but the actual type is bigint")
    public void testInvalidWindowFunctionCall() {
        Symbol windowSymbol = this.symbolAllocator.newSymbol("sum", (Type)DoubleType.DOUBLE);
        Signature signature = new Signature("sum", FunctionKind.WINDOW, (List)ImmutableList.of(), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false);
        FunctionCall functionCall = new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)this.columnA.toSymbolReference()));
        WindowNode.Frame frame = new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty());
        WindowNode.Function function = new WindowNode.Function(functionCall, signature, frame);
        WindowNode.Specification specification = new WindowNode.Specification((List)ImmutableList.of(), Optional.empty());
        WindowNode node = new WindowNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, specification, (Map)ImmutableMap.of((Object)windowSymbol, (Object)function), Optional.empty(), (Set)ImmutableSet.of(), 0);
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of symbol 'sum(_[0-9]+)?' is expected to be double, but the actual type is bigint")
    public void testInvalidWindowFunctionSignature() {
        Symbol windowSymbol = this.symbolAllocator.newSymbol("sum", (Type)DoubleType.DOUBLE);
        Signature signature = new Signature("sum", FunctionKind.WINDOW, (List)ImmutableList.of(), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false);
        FunctionCall functionCall = new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)this.columnC.toSymbolReference()));
        WindowNode.Frame frame = new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty());
        WindowNode.Function function = new WindowNode.Function(functionCall, signature, frame);
        WindowNode.Specification specification = new WindowNode.Specification((List)ImmutableList.of(), Optional.empty());
        WindowNode node = new WindowNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, specification, (Map)ImmutableMap.of((Object)windowSymbol, (Object)function), Optional.empty(), (Set)ImmutableSet.of(), 0);
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of symbol 'output(_[0-9]+)?' is expected to be date, but the actual type is bigint")
    public void testInvalidUnion() {
        Symbol outputSymbol = this.symbolAllocator.newSymbol("output", (Type)DateType.DATE);
        ImmutableListMultimap mappings = ImmutableListMultimap.builder().put((Object)outputSymbol, (Object)this.columnD).put((Object)outputSymbol, (Object)this.columnA).build();
        UnionNode node = new UnionNode(TestTypeValidator.newId(), (List)ImmutableList.of((Object)this.baseTableScan, (Object)this.baseTableScan), (ListMultimap)mappings, (List)ImmutableList.copyOf((Collection)mappings.keySet()));
        this.assertTypesValid((PlanNode)node);
    }

    private void assertTypesValid(PlanNode node) {
        TYPE_VALIDATOR.validate(node, SessionTestUtils.TEST_SESSION, (Metadata)MetadataManager.createTestMetadataManager(), SQL_PARSER, this.symbolAllocator.getTypes());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }
}

