/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AggregationFunctionMatcher
implements RvalueMatcher {
    private final ExpectedValueProvider<FunctionCall> callMaker;

    public AggregationFunctionMatcher(ExpectedValueProvider<FunctionCall> callMaker) {
        this.callMaker = Objects.requireNonNull(callMaker, "functionCall is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<Object> result = Optional.empty();
        if (!(node instanceof AggregationNode)) {
            return result;
        }
        AggregationNode aggregationNode = (AggregationNode)node;
        FunctionCall expectedCall = this.callMaker.getExpectedValue(symbolAliases);
        for (Map.Entry assignment : aggregationNode.getAggregations().entrySet()) {
            if (!expectedCall.equals((Object)((AggregationNode.Aggregation)assignment.getValue()).getCall())) continue;
            Preconditions.checkState((!result.isPresent() ? 1 : 0) != 0, (String)"Ambiguous function calls in %s", (Object)aggregationNode);
            result = Optional.of(assignment.getKey());
        }
        return result;
    }

    public String toString() {
        return this.callMaker.toString();
    }
}

