/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Objects;
import java.util.Optional;

public class AliasMatcher
implements Matcher {
    private final Optional<String> alias;
    private final RvalueMatcher matcher;

    AliasMatcher(Optional<String> alias, RvalueMatcher matcher) {
        this.alias = Objects.requireNonNull(alias, "alias is null");
        this.matcher = Objects.requireNonNull(matcher, "matcher is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<Symbol> symbol = this.matcher.getAssignedSymbol(node, session, metadata, symbolAliases);
        if (symbol.isPresent() && this.alias.isPresent()) {
            return MatchResult.match(this.alias.get(), symbol.get().toSymbolReference());
        }
        return new MatchResult(symbol.isPresent());
    }

    public String toString() {
        if (this.alias.isPresent()) {
            return String.format("bind %s -> %s", this.alias.get(), this.matcher);
        }
        return String.format("bind %s", this.matcher);
    }
}

