/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public abstract class BaseStrictSymbolsMatcher
implements Matcher {
    private final Function<PlanNode, Set<Symbol>> getActual;

    public BaseStrictSymbolsMatcher(Function<PlanNode, Set<Symbol>> getActual) {
        this.getActual = Objects.requireNonNull(getActual, "getActual is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        try {
            this.getActual.apply(node);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        return new MatchResult(this.getActual.apply(node).equals(this.getExpectedSymbols(node, session, metadata, symbolAliases)));
    }

    protected abstract Set<Symbol> getExpectedSymbols(PlanNode var1, Session var2, Metadata var3, SymbolAliases var4);
}

