/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ColumnReference
implements RvalueMatcher {
    private final String tableName;
    private final String columnName;

    public ColumnReference(String tableName, String columnName) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Map assignments;
        TableHandle tableHandle;
        if (node instanceof TableScanNode) {
            TableScanNode tableScanNode = (TableScanNode)node;
            tableHandle = tableScanNode.getTable();
            assignments = tableScanNode.getAssignments();
        } else if (node instanceof IndexSourceNode) {
            IndexSourceNode indexSourceNode = (IndexSourceNode)node;
            tableHandle = indexSourceNode.getTableHandle();
            assignments = indexSourceNode.getAssignments();
        } else {
            return Optional.empty();
        }
        TableMetadata tableMetadata = metadata.getTableMetadata(session, tableHandle);
        String actualTableName = tableMetadata.getTable().getTableName();
        if (!this.tableName.equalsIgnoreCase(actualTableName)) {
            return Optional.empty();
        }
        Optional<ColumnHandle> columnHandle = this.getColumnHandle(tableHandle, session, metadata);
        Preconditions.checkState((boolean)columnHandle.isPresent(), (Object)String.format("Table %s doesn't have column %s. Typo in test?", this.tableName, this.columnName));
        return this.getAssignedSymbol(assignments, columnHandle.get());
    }

    private Optional<Symbol> getAssignedSymbol(Map<Symbol, ColumnHandle> assignments, ColumnHandle columnHandle) {
        Optional<Symbol> result = Optional.empty();
        for (Map.Entry<Symbol, ColumnHandle> entry : assignments.entrySet()) {
            if (!entry.getValue().equals(columnHandle)) continue;
            Preconditions.checkState((!result.isPresent() ? 1 : 0) != 0, (String)"Multiple ColumnHandles found for %s:%s in table scan assignments", (Object)this.tableName, (Object)this.columnName);
            result = Optional.of(entry.getKey());
        }
        return result;
    }

    private Optional<ColumnHandle> getColumnHandle(TableHandle tableHandle, Session session, Metadata metadata) {
        return metadata.getColumnHandles(session, tableHandle).entrySet().stream().filter(entry -> this.columnName.equals(entry.getKey())).map(Map.Entry::getValue).findFirst();
    }

    public String toString() {
        return String.format("Column %s:%s", this.tableName, this.columnName);
    }
}

