/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExpressionMatcher
implements RvalueMatcher {
    private final String sql;
    private final Expression expression;

    public ExpressionMatcher(String expression) {
        this.sql = Objects.requireNonNull(expression);
        this.expression = this.expression(Objects.requireNonNull(expression));
    }

    private Expression expression(String sql) {
        SqlParser parser = new SqlParser();
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)parser.createExpression(sql));
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<Symbol> result = Optional.empty();
        ImmutableList.Builder matchesBuilder = ImmutableList.builder();
        Map<Symbol, Expression> assignments = ExpressionMatcher.getAssignments(node);
        if (assignments == null) {
            return result;
        }
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
            if (!((Boolean)verifier.process((Node)assignment.getValue(), this.expression)).booleanValue()) continue;
            result = Optional.of(assignment.getKey());
            matchesBuilder.add((Object)assignment.getValue());
        }
        ImmutableList matches = matchesBuilder.build();
        Preconditions.checkState((matches.size() < 2 ? 1 : 0) != 0, (String)"Ambiguous expression %s matches multiple assignments", (Object)this.expression, (Object)matches.stream().map(Expression::toString).collect(Collectors.joining(", ")));
        return result;
    }

    private static Map<Symbol, Expression> getAssignments(PlanNode node) {
        if (node instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)node;
            return projectNode.getAssignments().getMap();
        }
        if (node instanceof ApplyNode) {
            ApplyNode applyNode = (ApplyNode)node;
            return applyNode.getSubqueryAssignments().getMap();
        }
        return null;
    }

    public String toString() {
        return this.sql;
    }
}

