/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.assertions.ExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

final class FilterMatcher
implements Matcher {
    private final Expression predicate;

    FilterMatcher(Expression predicate) {
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof FilterNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        FilterNode filterNode = (FilterNode)node;
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        return new MatchResult((Boolean)verifier.process((Node)filterNode.getPredicate(), this.predicate));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("predicate", (Object)this.predicate).toString();
    }
}

