/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.assertions.AggregationMatcher;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GroupIdMatcher
implements Matcher {
    private final List<List<String>> groups;
    private final Map<String, String> identityMappings;
    private final String groupIdAlias;

    public GroupIdMatcher(List<List<String>> groups, Map<String, String> identityMappings, String groupIdAlias) {
        this.groups = groups;
        this.identityMappings = identityMappings;
        this.groupIdAlias = groupIdAlias;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof GroupIdNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        GroupIdNode groudIdNode = (GroupIdNode)node;
        List actualGroups = groudIdNode.getGroupingSets();
        List actualAggregationArguments = groudIdNode.getAggregationArguments();
        if (actualGroups.size() != this.groups.size()) {
            return MatchResult.NO_MATCH;
        }
        for (int i = 0; i < actualGroups.size(); ++i) {
            if (AggregationMatcher.matches((Collection<String>)this.groups.get(i), (Collection)actualGroups.get(i), symbolAliases)) continue;
            return MatchResult.NO_MATCH;
        }
        if (!AggregationMatcher.matches(this.identityMappings.keySet(), actualAggregationArguments, symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match(this.groupIdAlias, groudIdNode.getGroupIdSymbol().toSymbolReference());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groups", this.groups).toString();
    }
}

