/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.assertions.Util;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class IndexSourceMatcher
implements Matcher {
    private final String expectedTableName;
    private final Optional<Map<String, Domain>> expectedConstraint;

    public IndexSourceMatcher(String expectedTableName) {
        this.expectedTableName = Objects.requireNonNull(expectedTableName, "expectedTableName is null");
        this.expectedConstraint = Optional.empty();
    }

    public IndexSourceMatcher(String expectedTableName, Map<String, Domain> expectedConstraint) {
        this.expectedTableName = Objects.requireNonNull(expectedTableName, "expectedTableName is null");
        this.expectedConstraint = Optional.of(ImmutableMap.copyOf(expectedConstraint));
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof IndexSourceNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        IndexSourceNode indexSourceNode = (IndexSourceNode)node;
        TableMetadata tableMetadata = metadata.getTableMetadata(session, indexSourceNode.getTableHandle());
        String actualTableName = tableMetadata.getTable().getTableName();
        if (!this.expectedTableName.equalsIgnoreCase(actualTableName)) {
            return MatchResult.NO_MATCH;
        }
        if (this.expectedConstraint.isPresent() && !Util.domainsMatch(this.expectedConstraint, (TupleDomain<ColumnHandle>)indexSourceNode.getCurrentConstraint(), indexSourceNode.getTableHandle(), session, metadata)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("expectedTableName", (Object)this.expectedTableName).add("expectedConstraint", this.expectedConstraint.orElse(null)).toString();
    }
}

