/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Preconditions;

public class LimitMatcher
implements Matcher {
    private final long limit;

    public LimitMatcher(long limit) {
        this.limit = limit;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof LimitNode)) {
            return false;
        }
        LimitNode limitNode = (LimitNode)node;
        return limitNode.getCount() == this.limit;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node));
        return MatchResult.match();
    }
}

