/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class OutputMatcher
implements Matcher {
    private final List<String> aliases;

    OutputMatcher(List<String> aliases) {
        this.aliases = ImmutableList.copyOf((Collection)Objects.requireNonNull(aliases, "aliases is null"));
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        int i = 0;
        for (String alias : this.aliases) {
            SymbolReference expression = symbolAliases.get(alias);
            boolean found = false;
            while (i < node.getOutputSymbols().size()) {
                Symbol outputSymbol = (Symbol)node.getOutputSymbols().get(i++);
                if (!expression.equals((Object)outputSymbol.toSymbolReference())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("outputs", this.aliases).toString();
    }
}

