/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.PlanMatchingVisitor;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Plans;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;

public final class PlanAssert {
    private PlanAssert() {
    }

    public static void assertPlan(Session session, Metadata metadata, StatsCalculator statsCalculator, Plan actual, PlanMatchPattern pattern) {
        PlanAssert.assertPlan(session, metadata, statsCalculator, actual, Lookup.noLookup(), pattern);
    }

    public static void assertPlan(Session session, Metadata metadata, StatsCalculator statsCalculator, Plan actual, Lookup lookup, PlanMatchPattern pattern) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, session, actual.getTypes());
        PlanAssert.assertPlan(session, metadata, (StatsProvider)statsProvider, actual, lookup, pattern);
    }

    public static void assertPlan(Session session, Metadata metadata, StatsProvider statsProvider, Plan actual, Lookup lookup, PlanMatchPattern pattern) {
        CostProvider costProvider = node -> PlanNodeCostEstimate.UNKNOWN_COST;
        MatchResult matches = (MatchResult)actual.getRoot().accept((PlanVisitor)new PlanMatchingVisitor(session, metadata, statsProvider, lookup), (Object)pattern);
        if (!matches.isMatch()) {
            String formattedPlan = PlanPrinter.textLogicalPlan((PlanNode)actual.getRoot(), (TypeProvider)actual.getTypes(), (FunctionRegistry)metadata.getFunctionRegistry(), (StatsProvider)statsProvider, (CostProvider)costProvider, (Session)session, (int)0);
            PlanNode resolvedPlan = Plans.resolveGroupReferences((PlanNode)actual.getRoot(), (Lookup)lookup);
            String resolvedFormattedPlan = PlanPrinter.textLogicalPlan((PlanNode)resolvedPlan, (TypeProvider)actual.getTypes(), (FunctionRegistry)metadata.getFunctionRegistry(), (StatsProvider)statsProvider, (CostProvider)costProvider, (Session)session, (int)0);
            throw new AssertionError((Object)String.format("Plan does not match, expected [\n\n%s\n] but found [\n\n%s\n] which resolves to [\n\n%s\n]", pattern, formattedPlan, resolvedFormattedPlan));
        }
    }
}

