/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

final class SemiJoinMatcher
implements Matcher {
    private final String sourceSymbolAlias;
    private final String filteringSymbolAlias;
    private final String outputAlias;

    SemiJoinMatcher(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias) {
        this.sourceSymbolAlias = Objects.requireNonNull(sourceSymbolAlias, "sourceSymbolAlias is null");
        this.filteringSymbolAlias = Objects.requireNonNull(filteringSymbolAlias, "filteringSymbolAlias is null");
        this.outputAlias = Objects.requireNonNull(outputAlias, "outputAlias is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof SemiJoinNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        SemiJoinNode semiJoinNode = (SemiJoinNode)node;
        if (!symbolAliases.get(this.sourceSymbolAlias).equals((Object)semiJoinNode.getSourceJoinSymbol().toSymbolReference()) || !symbolAliases.get(this.filteringSymbolAlias).equals((Object)semiJoinNode.getFilteringSourceJoinSymbol().toSymbolReference())) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match(this.outputAlias, semiJoinNode.getSemiJoinOutput().toSymbolReference());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filteringSymbolAlias", (Object)this.filteringSymbolAlias).add("sourceSymbolAlias", (Object)this.sourceSymbolAlias).add("outputAlias", (Object)this.outputAlias).toString();
    }
}

