/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.assertions.ExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class SpatialJoinMatcher
implements Matcher {
    private final JoinNode.Type type;
    private final Expression filter;

    public SpatialJoinMatcher(JoinNode.Type type, Expression filter) {
        this.type = type;
        this.filter = Objects.requireNonNull(filter, "filter can not be null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof JoinNode)) {
            return false;
        }
        JoinNode joinNode = (JoinNode)node;
        return joinNode.getType() == this.type && joinNode.isSpatialJoin();
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        JoinNode joinNode = (JoinNode)node;
        if (!joinNode.getFilter().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (!((Boolean)new ExpressionVerifier(symbolAliases).process((Node)joinNode.getFilter().get(), this.filter)).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).toString();
    }
}

