/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SpecificationProvider
implements ExpectedValueProvider<WindowNode.Specification> {
    private final List<SymbolAlias> partitionBy;
    private final List<SymbolAlias> orderBy;
    private final Map<SymbolAlias, SortOrder> orderings;

    SpecificationProvider(List<SymbolAlias> partitionBy, List<SymbolAlias> orderBy, Map<SymbolAlias, SortOrder> orderings) {
        this.partitionBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionBy, "partitionBy is null"));
        this.orderBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderBy, "orderBy is null"));
        this.orderings = ImmutableMap.copyOf(Objects.requireNonNull(orderings, "orderings is null"));
    }

    @Override
    public WindowNode.Specification getExpectedValue(SymbolAliases aliases) {
        Optional<Object> orderingScheme = Optional.empty();
        if (!this.orderBy.isEmpty()) {
            orderingScheme = Optional.of(new OrderingScheme((List)this.orderBy.stream().map(alias -> alias.toSymbol(aliases)).collect(ImmutableList.toImmutableList()), (Map)this.orderings.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((SymbolAlias)entry.getKey()).toSymbol(aliases), Map.Entry::getValue))));
        }
        return new WindowNode.Specification((List)this.partitionBy.stream().map(alias -> alias.toSymbol(aliases)).collect(ImmutableList.toImmutableList()), orderingScheme);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionBy", this.partitionBy).add("orderBy", this.orderBy).add("orderings", this.orderings).toString();
    }
}

