/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.assertions.ExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SymbolReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExpressionVerifier {
    private final SqlParser parser = new SqlParser();

    @Test
    public void test() {
        Expression actual = this.expression("NOT(orderkey = 3 AND custkey = 3 AND orderkey < 10)");
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).put("Y", new SymbolReference("custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)actual, this.expression("NOT(X = 3 AND Y = 3 AND X < 10)"))));
        TestExpressionVerifier.assertThrows(() -> {
            Boolean cfr_ignored_0 = (Boolean)verifier.process((Node)actual, this.expression("NOT(X = 3 AND Y = 3 AND Z < 10)"));
        });
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)actual, this.expression("NOT(X = 3 AND X = 3 AND X < 10)"))));
    }

    @Test
    public void testCast() {
        SymbolAliases aliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(aliases);
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("CAST('2' AS varchar)"), this.expression("CAST('2' AS varchar)"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("CAST('2' AS varchar)"), this.expression("CAST('2' AS bigint)"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("CAST(orderkey AS varchar)"), this.expression("CAST(X AS varchar)"))));
    }

    @Test
    public void testBetween() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).put("Y", new SymbolReference("custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 1 AND 2"), this.expression("X BETWEEN 1 AND 2"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 1 AND 2"), this.expression("Y BETWEEN 1 AND 2"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("custkey BETWEEN 1 AND 2"), this.expression("X BETWEEN 1 AND 2"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 2 AND 4"), this.expression("X BETWEEN 1 AND 2"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 1 AND 2"), this.expression("X BETWEEN '1' AND '2'"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 1 AND 2"), this.expression("X BETWEEN 4 AND 7"))));
    }

    private Expression expression(String sql) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)this.parser.createExpression(sql));
    }

    private static void assertThrows(Runnable runnable) {
        try {
            runnable.run();
            throw new AssertionError((Object)"Method didn't throw exception as expected");
        }
        catch (Exception exception) {
            return;
        }
    }
}

