/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.assertions.Util;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TopNMatcher
implements Matcher {
    private final long count;
    private final List<PlanMatchPattern.Ordering> orderBy;

    public TopNMatcher(long count, List<PlanMatchPattern.Ordering> orderBy) {
        this.count = count;
        this.orderBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderBy, "orderBy is null"));
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TopNNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TopNNode topNNode = (TopNNode)node;
        if (topNNode.getCount() != this.count) {
            return MatchResult.NO_MATCH;
        }
        if (!Util.orderingSchemeMatches(this.orderBy, topNNode.getOrderingScheme(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("orderBy", this.orderBy).toString();
    }
}

