/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class Util {
    private Util() {
    }

    static boolean domainsMatch(Optional<Map<String, Domain>> expectedDomains, TupleDomain<ColumnHandle> actualConstraint, TableHandle tableHandle, Session session, Metadata metadata) {
        Optional actualDomains = actualConstraint.getDomains();
        if (expectedDomains.isPresent() != actualDomains.isPresent()) {
            return false;
        }
        if (!expectedDomains.isPresent()) {
            return true;
        }
        Map columnHandles = metadata.getColumnHandles(session, tableHandle);
        for (Map.Entry<String, Domain> expectedColumnConstraint : expectedDomains.get().entrySet()) {
            if (!columnHandles.containsKey(expectedColumnConstraint.getKey())) {
                return false;
            }
            ColumnHandle columnHandle = (ColumnHandle)columnHandles.get(expectedColumnConstraint.getKey());
            if (!((Map)actualDomains.get()).containsKey(columnHandle)) {
                return false;
            }
            if (expectedColumnConstraint.getValue().contains((Domain)((Map)actualDomains.get()).get(columnHandle))) continue;
            return false;
        }
        return true;
    }

    static boolean orderingSchemeMatches(List<PlanMatchPattern.Ordering> expectedOrderBy, OrderingScheme orderingScheme, SymbolAliases symbolAliases) {
        if (expectedOrderBy.size() != orderingScheme.getOrderBy().size()) {
            return false;
        }
        for (int i = 0; i < expectedOrderBy.size(); ++i) {
            PlanMatchPattern.Ordering ordering = expectedOrderBy.get(i);
            Symbol symbol = Symbol.from((Expression)symbolAliases.get(ordering.getField()));
            if (!symbol.equals(orderingScheme.getOrderBy().get(i))) {
                return false;
            }
            if (ordering.getSortOrder().equals((Object)orderingScheme.getOrdering(symbol))) continue;
            return false;
        }
        return true;
    }
}

