/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ValuesMatcher
implements Matcher {
    private final Map<String, Integer> outputSymbolAliases;
    private final Optional<Integer> expectedOutputSymbolCount;
    private final Optional<List<List<Expression>>> expectedRows;

    public ValuesMatcher(Map<String, Integer> outputSymbolAliases, Optional<Integer> expectedOutputSymbolCount, Optional<List<List<Expression>>> expectedRows) {
        this.outputSymbolAliases = ImmutableMap.copyOf(outputSymbolAliases);
        this.expectedOutputSymbolCount = Objects.requireNonNull(expectedOutputSymbolCount, "expectedOutputSymbolCount is null");
        this.expectedRows = Objects.requireNonNull(expectedRows, "expectedRows is null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof ValuesNode)) return false;
        if (this.expectedOutputSymbolCount.map(node.getOutputSymbols().size()::equals).orElse(true) == false) return false;
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        ValuesNode valuesNode = (ValuesNode)node;
        if (!this.expectedRows.map(rows -> rows.equals(valuesNode.getRows())).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match(SymbolAliases.builder().putAll(Maps.transformValues(this.outputSymbolAliases, index -> ((Symbol)valuesNode.getOutputSymbols().get((int)index)).toSymbolReference())).build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("outputSymbolAliases", this.outputSymbolAliases).add("expectedOutputSymbolCount", this.expectedOutputSymbolCount).add("expectedRows", this.expectedRows).toString();
    }
}

