/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WindowFunctionMatcher
implements RvalueMatcher {
    private final ExpectedValueProvider<FunctionCall> callMaker;
    private final Optional<Signature> signature;
    private final Optional<ExpectedValueProvider<WindowNode.Frame>> frameMaker;

    public WindowFunctionMatcher(ExpectedValueProvider<FunctionCall> callMaker, Optional<Signature> signature, Optional<ExpectedValueProvider<WindowNode.Frame>> frameMaker) {
        this.callMaker = Objects.requireNonNull(callMaker, "functionCall is null");
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.frameMaker = Objects.requireNonNull(frameMaker, "frameMaker is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<Symbol> result = Optional.empty();
        if (!(node instanceof WindowNode)) {
            return result;
        }
        WindowNode windowNode = (WindowNode)node;
        FunctionCall expectedCall = this.callMaker.getExpectedValue(symbolAliases);
        Optional<WindowNode.Frame> expectedFrame = this.frameMaker.map(maker -> (WindowNode.Frame)maker.getExpectedValue(symbolAliases));
        List matchedOutputs = (List)windowNode.getWindowFunctions().entrySet().stream().filter(assignment -> {
            if (!expectedCall.equals((Object)((WindowNode.Function)assignment.getValue()).getFunctionCall())) return false;
            if (this.signature.map(arg_0 -> ((Signature)((WindowNode.Function)assignment.getValue()).getSignature()).equals(arg_0)).orElse(true) == false) return false;
            if (expectedFrame.map(arg_0 -> ((WindowNode.Frame)((WindowNode.Function)assignment.getValue()).getFrame()).equals(arg_0)).orElse(true) == false) return false;
            return true;
        }).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((matchedOutputs.size() <= 1 ? 1 : 0) != 0, (String)"Ambiguous function calls in %s", (Object)windowNode);
        if (matchedOutputs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(matchedOutputs.get(0));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("callMaker", this.callMaker).add("signature", this.signature.orElse(null)).add("frameMaker", this.frameMaker.orElse(null)).toString();
    }
}

