/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.AbstractMockMetadata;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.RuleIndex;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRuleIndex {
    private final PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());

    @Test
    public void testWithPlanNodeHierarchy() {
        NoOpRule projectRule1 = new NoOpRule(Pattern.typeOf(ProjectNode.class));
        NoOpRule projectRule2 = new NoOpRule(Pattern.typeOf(ProjectNode.class));
        NoOpRule filterRule = new NoOpRule(Pattern.typeOf(FilterNode.class));
        NoOpRule anyRule = new NoOpRule(Pattern.any());
        RuleIndex ruleIndex = RuleIndex.builder().register((Rule)projectRule1).register((Rule)projectRule2).register((Rule)filterRule).register((Rule)anyRule).build();
        ProjectNode projectNode = this.planBuilder.project(Assignments.of(), (PlanNode)this.planBuilder.values(new Symbol[0]));
        FilterNode filterNode = this.planBuilder.filter((Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)this.planBuilder.values(new Symbol[0]));
        ValuesNode valuesNode = this.planBuilder.values(new Symbol[0]);
        Assert.assertEquals(ruleIndex.getCandidates((Object)projectNode).collect(Collectors.toSet()), (Set)ImmutableSet.of((Object)projectRule1, (Object)projectRule2, (Object)anyRule));
        Assert.assertEquals(ruleIndex.getCandidates((Object)filterNode).collect(Collectors.toSet()), (Set)ImmutableSet.of((Object)filterRule, (Object)anyRule));
        Assert.assertEquals(ruleIndex.getCandidates((Object)valuesNode).collect(Collectors.toSet()), (Set)ImmutableSet.of((Object)anyRule));
    }

    @Test
    public void testInterfacesHierarchy() {
        NoOpRule a = new NoOpRule(Pattern.typeOf(A.class));
        NoOpRule b = new NoOpRule(Pattern.typeOf(B.class));
        NoOpRule ab = new NoOpRule(Pattern.typeOf(AB.class));
        RuleIndex ruleIndex = RuleIndex.builder().register((Rule)a).register((Rule)b).register((Rule)ab).build();
        Assert.assertEquals(ruleIndex.getCandidates((Object)new A(){}).collect(Collectors.toSet()), (Set)ImmutableSet.of((Object)a));
        Assert.assertEquals(ruleIndex.getCandidates((Object)new B(){}).collect(Collectors.toSet()), (Set)ImmutableSet.of((Object)b));
        Assert.assertEquals(ruleIndex.getCandidates((Object)new AB()).collect(Collectors.toSet()), (Set)ImmutableSet.of((Object)ab, (Object)a, (Object)b));
    }

    private static class AB
    implements A,
    B {
        private AB() {
        }
    }

    private static interface B {
    }

    private static interface A {
    }

    private static class NoOpRule
    implements Rule<PlanNode> {
        private final Pattern pattern;

        private NoOpRule(Pattern pattern) {
            this.pattern = pattern;
        }

        public Pattern<PlanNode> getPattern() {
            return this.pattern;
        }

        public Rule.Result apply(PlanNode node, Captures captures, Rule.Context context) {
            return Rule.Result.empty();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.pattern).toString();
        }
    }
}

