/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkReorderChainedJoins {
    @Benchmark
    public MaterializedResult benchmarkReorderJoins(BenchmarkInfo benchmarkInfo) {
        return benchmarkInfo.getQueryRunner().execute("EXPLAIN SELECT * FROM nation n1 JOIN nation n2 ON n1.nationkey = n2.nationkey JOIN nation n3 ON n2.comment = n3.comment JOIN nation n4 ON n3.name = n4.name JOIN region r1 ON n4.regionkey = r1.regionkey JOIN region r2 ON r1.name = r2.name JOIN region r3 ON r3.comment = r2.comment JOIN region r4 ON r4.regionkey = r3.regionkey");
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkReorderChainedJoins.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkInfo {
        @Param(value={"ELIMINATE_CROSS_JOINS", "AUTOMATIC"})
        private String joinReorderingStrategy;
        private LocalQueryRunner queryRunner;

        @Setup
        public void setup() {
            Session session = TestingSession.testSessionBuilder().setSystemProperty("join_reordering_strategy", this.joinReorderingStrategy).setSystemProperty("join_distribution_type", "AUTOMATIC").setCatalog("tpch").setSchema("tiny").build();
            this.queryRunner = new LocalQueryRunner(session);
            this.queryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        }

        public QueryRunner getQueryRunner() {
            return this.queryRunner;
        }

        @TearDown
        public void tearDown() {
            this.queryRunner.close();
        }
    }
}

