/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDetermineJoinDistributionType {
    private static final CostComparator COST_COMPARATOR = new CostComparator(1.0, 1.0, 1.0);
    private RuleTester tester;

    @BeforeClass
    public void setUp() {
        this.tester = new RuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of(), Optional.of(4));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.tester.close();
        this.tester = null;
    }

    private RuleTester tester() {
        return this.tester;
    }

    @Test
    public void testDetermineDistributionType() {
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinNode.Type.INNER, JoinNode.DistributionType.PARTITIONED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST, JoinNode.Type.INNER, JoinNode.DistributionType.REPLICATED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinNode.Type.INNER, JoinNode.DistributionType.PARTITIONED);
    }

    @Test
    public void testDetermineDistributionTypeForLeftOuter() {
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinNode.Type.LEFT, JoinNode.DistributionType.PARTITIONED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST, JoinNode.Type.LEFT, JoinNode.DistributionType.REPLICATED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinNode.Type.LEFT, JoinNode.DistributionType.PARTITIONED);
    }

    private void testDetermineDistributionType(FeaturesConfig.JoinDistributionType sessionDistributedJoin, JoinNode.Type joinType, JoinNode.DistributionType expectedDistribution) {
        this.tester().assertThat((Rule)new DetermineJoinDistributionType(COST_COMPARATOR)).on(p -> p.join(joinType, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11"))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", sessionDistributedJoin.name()).matches(PlanMatchPattern.join(joinType, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(expectedDistribution), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionRightOuter() {
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinNode.Type.FULL);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinNode.Type.RIGHT);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.BROADCAST, JoinNode.Type.FULL);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.BROADCAST, JoinNode.Type.RIGHT);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinNode.Type.FULL);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinNode.Type.RIGHT);
    }

    private void testRepartitionRightOuter(FeaturesConfig.JoinDistributionType sessionDistributedJoin, JoinNode.Type joinType) {
        this.tester().assertThat((Rule)new DetermineJoinDistributionType(COST_COMPARATOR)).on(p -> p.join(joinType, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11"))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", sessionDistributedJoin.name()).matches(PlanMatchPattern.join(joinType, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicateScalar() {
        this.tester().assertThat((Rule)new DetermineJoinDistributionType(COST_COMPARATOR)).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.enforceSingleRow((PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11")))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.enforceSingleRow(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicateNoEquiCriteria() {
        this.testReplicateNoEquiCriteria(JoinNode.Type.INNER);
        this.testReplicateNoEquiCriteria(JoinNode.Type.LEFT);
    }

    private void testReplicateNoEquiCriteria(JoinNode.Type joinType) {
        this.tester().assertThat((Rule)new DetermineJoinDistributionType(COST_COMPARATOR)).on(p -> p.join(joinType, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11"))), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.of(PlanBuilder.expression("A1 * B1 > 100")))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).matches(PlanMatchPattern.join(joinType, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("A1 * B1 > 100"), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testRetainDistributionType() {
        this.tester().assertThat((Rule)new DetermineJoinDistributionType(COST_COMPARATOR)).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11"))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED))).doesNotFire();
    }

    @Test
    public void testFlipAndReplicateWhenOneTableMuchSmaller() {
        int aRows = 100;
        int bRows = 10000;
        this.tester.assertThat((Rule)new DetermineJoinDistributionType(COST_COMPARATOR)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testPartitionWhenRequiredBySession() {
        int aRows = 100;
        int bRows = 10000;
        this.tester.assertThat((Rule)new DetermineJoinDistributionType(new CostComparator(1.0, 1.0, 1.0))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testPartitionWhenBothTablesEqual() {
        int aRows = 10000;
        int bRows = 10000;
        this.tester.assertThat((Rule)new DetermineJoinDistributionType(new CostComparator(1.0, 1.0, 1.0))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatesWhenRequiredBySession() {
        int aRows = 10000;
        int bRows = 10000;
        this.tester.assertThat((Rule)new DetermineJoinDistributionType(new CostComparator(1.0, 1.0, 1.0))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testPartitionFullOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.tester.assertThat((Rule)new DetermineJoinDistributionType(new CostComparator(1.0, 1.0, 1.0))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testPartitionRightOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.tester.assertThat((Rule)new DetermineJoinDistributionType(new CostComparator(1.0, 1.0, 1.0))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicateLeftOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.tester.assertThat((Rule)new DetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testFlipAndReplicateRightOuterJoin() {
        int aRows = 10;
        int bRows = 1000000;
        this.tester.assertThat((Rule)new DetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }
}

