/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.EliminateCrossJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.joins.JoinGraph;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestEliminateCrossJoins
extends BaseRuleTest {
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();

    public TestEliminateCrossJoins() {
        super(new Plugin[0]);
    }

    @Test
    public void testEliminateCrossJoin() {
        this.tester().assertThat((Rule)new EliminateCrossJoins()).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(this.crossJoinAndJoin(JoinNode.Type.INNER)).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(new Symbol("cySymbol"), new Symbol("bySymbol"))), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(new Symbol("axSymbol"), new Symbol("cxSymbol"))), PlanMatchPattern.any(new PlanMatchPattern[0]), PlanMatchPattern.any(new PlanMatchPattern[0])), PlanMatchPattern.any(new PlanMatchPattern[0])));
    }

    @Test
    public void testRetainOutgoingGroupReferences() {
        this.tester().assertThat((Rule)new EliminateCrossJoins()).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(this.crossJoinAndJoin(JoinNode.Type.INNER)).matches(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(GroupReference.class, new PlanMatchPattern[0]), PlanMatchPattern.node(GroupReference.class, new PlanMatchPattern[0])), PlanMatchPattern.node(GroupReference.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testDoNotReorderOuterJoin() {
        this.tester().assertThat((Rule)new EliminateCrossJoins()).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(this.crossJoinAndJoin(JoinNode.Type.LEFT)).doesNotFire();
    }

    @Test
    public void testIsOriginalOrder() {
        Assert.assertTrue((boolean)EliminateCrossJoins.isOriginalOrder((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4)));
        Assert.assertFalse((boolean)EliminateCrossJoins.isOriginalOrder((List)ImmutableList.of((Object)0, (Object)2, (Object)1, (Object)3, (Object)4)));
    }

    @Test
    public void testJoinOrder() {
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.symbol("a")), (PlanNode)this.values(this.symbol("b")), new String[0]), (PlanNode)this.values(this.symbol("c")), this.symbol("a"), this.symbol("c"), this.symbol("c"), this.symbol("b"));
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)2, (Object)1));
    }

    @Test
    public void testJoinOrderWithRealCrossJoin() {
        JoinNode leftPlan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.symbol("a")), (PlanNode)this.values(this.symbol("b")), new String[0]), (PlanNode)this.values(this.symbol("c")), this.symbol("a"), this.symbol("c"), this.symbol("c"), this.symbol("b"));
        JoinNode rightPlan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.symbol("x")), (PlanNode)this.values(this.symbol("y")), new String[0]), (PlanNode)this.values(this.symbol("z")), this.symbol("x"), this.symbol("z"), this.symbol("z"), this.symbol("y"));
        JoinNode plan = this.joinNode((PlanNode)leftPlan, (PlanNode)rightPlan, new String[0]);
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)2, (Object)1, (Object)3, (Object)5, (Object)4));
    }

    @Test
    public void testJoinOrderWithMultipleEdgesBetweenNodes() {
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.symbol("a")), (PlanNode)this.values(this.symbol("b1"), this.symbol("b2")), new String[0]), (PlanNode)this.values(this.symbol("c1"), this.symbol("c2")), this.symbol("a"), this.symbol("c1"), this.symbol("c1"), this.symbol("b1"), this.symbol("c2"), this.symbol("b2"));
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)2, (Object)1));
    }

    @Test
    public void testDonNotChangeOrderWithoutCrossJoin() {
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.symbol("a")), (PlanNode)this.values(this.symbol("b")), this.symbol("a"), this.symbol("b")), (PlanNode)this.values(this.symbol("c")), this.symbol("c"), this.symbol("b"));
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)1, (Object)2));
    }

    @Test
    public void testDoNotReorderCrossJoins() {
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.symbol("a")), (PlanNode)this.values(this.symbol("b")), new String[0]), (PlanNode)this.values(this.symbol("c")), this.symbol("c"), this.symbol("b"));
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)1, (Object)2));
    }

    @Test
    public void testGiveUpOnNonIdentityProjections() {
        JoinNode plan = this.joinNode(this.projectNode((PlanNode)this.joinNode((PlanNode)this.values(this.symbol("a1")), (PlanNode)this.values(this.symbol("b")), new String[0]), this.symbol("a2"), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("a1"))), (PlanNode)this.values(this.symbol("c")), this.symbol("a2"), this.symbol("c"), this.symbol("c"), this.symbol("b"));
        Assert.assertEquals((int)JoinGraph.buildFrom((PlanNode)plan).size(), (int)2);
    }

    private Function<PlanBuilder, PlanNode> crossJoinAndJoin(JoinNode.Type secondJoinType) {
        return p -> {
            Symbol axSymbol = p.symbol("axSymbol");
            Symbol bySymbol = p.symbol("bySymbol");
            Symbol cxSymbol = p.symbol("cxSymbol");
            Symbol cySymbol = p.symbol("cySymbol");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.join(secondJoinType, (PlanNode)p.values(axSymbol), (PlanNode)p.values(bySymbol), new JoinNode.EquiJoinClause[0]), (PlanNode)p.values(cxSymbol, cySymbol), new JoinNode.EquiJoinClause(cxSymbol, axSymbol), new JoinNode.EquiJoinClause(cySymbol, bySymbol));
        };
    }

    private PlanNode projectNode(PlanNode source, String symbol, Expression expression) {
        return new ProjectNode(this.idAllocator.getNextId(), source, Assignments.of((Symbol)new Symbol(symbol), (Expression)expression));
    }

    private String symbol(String name) {
        return name;
    }

    private JoinNode joinNode(PlanNode left, PlanNode right, String ... symbols) {
        Preconditions.checkArgument((symbols.length % 2 == 0 ? 1 : 0) != 0);
        ImmutableList.Builder criteria = ImmutableList.builder();
        for (int i = 0; i < symbols.length; i += 2) {
            criteria.add((Object)new JoinNode.EquiJoinClause(new Symbol(symbols[i]), new Symbol(symbols[i + 1])));
        }
        return new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.INNER, left, right, (List)criteria.build(), (List)ImmutableList.builder().addAll((Iterable)left.getOutputSymbols()).addAll((Iterable)right.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private ValuesNode values(String ... symbols) {
        return new ValuesNode(this.idAllocator.getNextId(), (List)Arrays.stream(symbols).map(Symbol::new).collect(ImmutableList.toImmutableList()), (List)ImmutableList.of());
    }
}

