/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.GatherAndMergeWindows;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public class TestMergeAdjacentWindows
extends BaseRuleTest {
    private static final WindowNode.Frame frame = new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty());
    private static final Signature signature = new Signature("avg", FunctionKind.WINDOW, (List)ImmutableList.of(), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false);
    private static final String columnAAlias = "ALIAS_A";
    private static final ExpectedValueProvider<WindowNode.Specification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"ALIAS_A"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());
    private static final Optional<Window> windowA = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()));

    public TestMergeAdjacentWindows() {
        super(new Plugin[0]);
    }

    @Test
    public void testPlanWithoutWindowNode() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void testPlanWithSingleWindowNode() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)this.newWindowNodeFunction("avg", "a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testDistinctAdjacentWindowSpecifications() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)this.newWindowNodeFunction("avg", "a")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "b"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("sum_1"), (Object)this.newWindowNodeFunction("sum", "b")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testIntermediateNonProjectNode() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(1)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)this.newWindowNodeFunction("avg", "a")), (PlanNode)p.filter(PlanBuilder.expression("a > 5"), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)this.newWindowNodeFunction("avg", "a")), (PlanNode)p.values(p.symbol("a")))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsIdenticalSpecifications() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)this.newWindowNodeFunction("avg", windowA, "avg_2")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)this.newWindowNodeFunction("avg", windowA, "a")), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsDistinctSpecifications() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)this.newWindowNodeFunction("avg", windowA, "avg_2")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "b"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)this.newWindowNodeFunction("avg", windowA, "a")), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testIdenticalAdjacentWindowSpecifications() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)this.newWindowNodeFunction("avg", windowA, "a")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("sum_1"), (Object)this.newWindowNodeFunction("sum", windowA, "a")), (PlanNode)p.values(p.symbol("a"))))).matches(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))).addFunction(PlanMatchPattern.functionCall("sum", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)columnAAlias, (Object)0))));
    }

    @Test
    public void testIntermediateProjectNodes() {
        String oneAlias = "ALIAS_one";
        String unusedAlias = "ALIAS_unused";
        String lagOutputAlias = "ALIAS_lagOutput";
        String avgOutputAlias = "ALIAS_avgOutput";
        this.tester().assertThat((Rule)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(2)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("lagOutput"), (Object)this.newWindowNodeFunction("lag", windowA, "a", "one")), (PlanNode)p.project(Assignments.builder().put(p.symbol("one"), PlanBuilder.expression("CAST(1 AS bigint)")).putIdentities((Iterable)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("avgOutput"))).build(), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("a"), p.symbol("avgOutput"), p.symbol("unused")}), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avgOutput"), (Object)this.newWindowNodeFunction("avg", windowA, "a")), (PlanNode)p.values(p.symbol("a"), p.symbol("unused"))))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)columnAAlias, (Object)PlanMatchPattern.expression(columnAAlias), (Object)oneAlias, (Object)PlanMatchPattern.expression(oneAlias), (Object)lagOutputAlias, (Object)PlanMatchPattern.expression(lagOutputAlias), (Object)avgOutputAlias, (Object)PlanMatchPattern.expression(avgOutputAlias)), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(lagOutputAlias, PlanMatchPattern.functionCall("lag", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias, (Object)oneAlias))).addFunction(avgOutputAlias, PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)oneAlias, (Object)PlanMatchPattern.expression("CAST(1 AS bigint)"), (Object)columnAAlias, (Object)PlanMatchPattern.expression(columnAAlias), (Object)unusedAlias, (Object)PlanMatchPattern.expression(unusedAlias)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)columnAAlias, (Object)PlanMatchPattern.expression(columnAAlias), (Object)unusedAlias, (Object)PlanMatchPattern.expression(unusedAlias)), PlanMatchPattern.values(columnAAlias, unusedAlias))))));
    }

    private static WindowNode.Specification newWindowNodeSpecification(PlanBuilder planBuilder, String symbolName) {
        return new WindowNode.Specification((List)ImmutableList.of((Object)planBuilder.symbol(symbolName, (Type)BigintType.BIGINT)), Optional.empty());
    }

    private WindowNode.Function newWindowNodeFunction(String functionName, String ... symbols) {
        return new WindowNode.Function(new FunctionCall(QualifiedName.of((String)functionName), Arrays.stream(symbols).map(SymbolReference::new).collect(Collectors.toList())), signature, frame);
    }

    private WindowNode.Function newWindowNodeFunction(String functionName, Optional<Window> window, String ... symbols) {
        return new WindowNode.Function(new FunctionCall(QualifiedName.of((String)functionName), window, false, Arrays.stream(symbols).map(SymbolReference::new).collect(Collectors.toList())), signature, frame);
    }
}

