/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PickTableLayout;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPickTableLayout
extends BaseRuleTest {
    private PickTableLayout pickTableLayout;
    private TableHandle nationTableHandle;
    private TableLayoutHandle nationTableLayoutHandle;
    private ConnectorId connectorId;

    public TestPickTableLayout() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setUpBeforeClass() {
        this.pickTableLayout = new PickTableLayout(this.tester().getMetadata());
        this.connectorId = this.tester().getCurrentConnectorId();
        this.nationTableHandle = new TableHandle(this.connectorId, (ConnectorTableHandle)new TpchTableHandle(this.connectorId.toString(), "nation", 1.0));
        this.nationTableLayoutHandle = new TableLayoutHandle(this.connectorId, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorTableLayoutHandle)new TpchTableLayoutHandle((TpchTableHandle)this.nationTableHandle.getConnectorHandle(), TupleDomain.all()));
    }

    @Test
    public void doesNotFireIfNoTableScan() {
        for (Rule rule : this.pickTableLayout.rules()) {
            this.tester().assertThat(rule).on(p -> p.values(p.symbol("a", (Type)BigintType.BIGINT))).doesNotFire();
        }
    }

    @Test
    public void doesNotFireIfTableScanHasTableLayout() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutWithoutPredicate()).on(p -> p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), Optional.of(this.nationTableLayoutHandle))).doesNotFire();
    }

    @Test
    public void eliminateTableScanWhenNoLayoutExist() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), Optional.of(this.nationTableLayoutHandle)))).matches(PlanMatchPattern.filter("nationkey = BIGINT '44'", PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))));
    }

    @Test
    public void replaceWithExistsWhenNoLayoutExist() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(arg_0 -> this.lambda$replaceWithExistsWhenNoLayoutExist$3((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.values("A"));
    }

    @Test
    public void doesNotFireIfRuleNotChangePlan() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> p.filter(PlanBuilder.expression("nationkey % 17 =  BIGINT '44' AND nationkey % 15 =  BIGINT '43'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), Optional.of(this.nationTableLayoutHandle), (TupleDomain<ColumnHandle>)TupleDomain.all()))).doesNotFire();
    }

    @Test
    public void ruleAddedTableLayoutToTableScan() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutWithoutPredicate()).on(p -> p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)))).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void ruleAddedTableLayoutToFilterTableScan() {
        ImmutableMap filterConstraint = ImmutableMap.builder().put((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)).build();
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.filter("nationkey = BIGINT '44'", PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)filterConstraint, (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))));
    }

    @Test
    public void ruleAddedNewTableLayoutIfTableScanHasEmptyConstraint() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), Optional.of(this.nationTableLayoutHandle)))).matches(PlanMatchPattern.filter("nationkey = BIGINT '44'", PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))));
    }

    @Test
    public void ruleWithPushdownableToTableLayoutPredicate() {
        TableHandle ordersTableHandle = new TableHandle(this.connectorId, (ConnectorTableHandle)new TpchTableHandle(this.connectorId.toString(), "orders", 1.0));
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(arg_0 -> TestPickTableLayout.lambda$ruleWithPushdownableToTableLayoutPredicate$8(ordersTableHandle, (Type)orderStatusType, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void nonDeterministicPredicate() {
        TableHandle ordersTableHandle = new TableHandle(this.connectorId, (ConnectorTableHandle)new TpchTableHandle(this.connectorId.toString(), "orders", 1.0));
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(arg_0 -> TestPickTableLayout.lambda$nonDeterministicPredicate$9(ordersTableHandle, (Type)orderStatusType, arg_0)).matches(PlanMatchPattern.filter("rand() = 0", PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))));
    }

    private static /* synthetic */ PlanNode lambda$nonDeterministicPredicate$9(TableHandle ordersTableHandle, Type orderStatusType, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("orderstatus = 'O' AND rand() = 0"), (PlanNode)p.tableScan(ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", orderStatusType)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private static /* synthetic */ PlanNode lambda$ruleWithPushdownableToTableLayoutPredicate$8(TableHandle ordersTableHandle, Type orderStatusType, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("orderstatus = 'O'"), (PlanNode)p.tableScan(ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", orderStatusType)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private /* synthetic */ PlanNode lambda$replaceWithExistsWhenNoLayoutExist$3(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), Optional.of(this.nationTableLayoutHandle), (TupleDomain<ColumnHandle>)TupleDomain.none()));
    }
}

