/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneAggregationSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneAggregationSourceColumns
extends BaseRuleTest {
    public TestPruneAggregationSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneAggregationSourceColumns()).on(p -> this.buildAggregation((PlanBuilder)p, (Predicate<Symbol>)Predicates.alwaysTrue())).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("avg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"input"))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"input", (Object)PlanMatchPattern.expression("input"), (Object)"key", (Object)PlanMatchPattern.expression("key"), (Object)"keyHash", (Object)PlanMatchPattern.expression("keyHash"), (Object)"mask", (Object)PlanMatchPattern.expression("mask")), PlanMatchPattern.values("input", "key", "keyHash", "mask", "unused"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneAggregationSourceColumns()).on(p -> this.buildAggregation((PlanBuilder)p, symbol -> !symbol.getName().equals("unused"))).doesNotFire();
    }

    private AggregationNode buildAggregation(PlanBuilder planBuilder, Predicate<Symbol> sourceSymbolFilter) {
        Symbol avg = planBuilder.symbol("avg");
        Symbol input = planBuilder.symbol("input");
        Symbol key = planBuilder.symbol("key");
        Symbol keyHash = planBuilder.symbol("keyHash");
        Symbol mask = planBuilder.symbol("mask");
        Symbol unused = planBuilder.symbol("unused");
        ImmutableList sourceSymbols = ImmutableList.of((Object)input, (Object)key, (Object)keyHash, (Object)mask, (Object)unused);
        return planBuilder.aggregation(arg_0 -> TestPruneAggregationSourceColumns.lambda$buildAggregation$3(key, avg, planBuilder, mask, keyHash, (List)sourceSymbols, sourceSymbolFilter, arg_0));
    }

    private static /* synthetic */ void lambda$buildAggregation$3(Symbol key, Symbol avg, PlanBuilder planBuilder, Symbol mask, Symbol keyHash, List sourceSymbols, Predicate sourceSymbolFilter, PlanBuilder.AggregationBuilder aggregationBuilder) {
        aggregationBuilder.singleGroupingSet(key).addAggregation(avg, PlanBuilder.expression("avg(input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).hashSymbol(keyHash).source((PlanNode)planBuilder.values((List)sourceSymbols.stream().filter(sourceSymbolFilter).collect(ImmutableList.toImmutableList()), (List<List<Expression>>)ImmutableList.of()));
    }
}

