/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneCountAggregationOverScalar
extends BaseRuleTest {
    public TestPruneCountAggregationOverScalar() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNonNestedAggregate() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.globalGrouping().addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of())))).doesNotFire();
    }

    @Test
    public void testFiresOnNestedCountAggregate() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().step(AggregationNode.Step.SINGLE).source((PlanNode)p.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of())).globalGrouping().step(AggregationNode.Step.SINGLE))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testFiresOnCountAggregateOverValues() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("orderkey")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("1")))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testFiresOnCountAggregateOverEnforceSingleRow() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.enforceSingleRow((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testDoesNotFireOnNestedCountAggregateWithNonEmptyGroupBy() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.aggregation(aggregationBuilder -> {
            aggregationBuilder.source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of())).groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)p.symbol("orderkey"))));
            aggregationBuilder.source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()));
        })))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnNestedNonCountAggregate() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> {
            Symbol totalPrice = p.symbol("total_price", (Type)DoubleType.DOUBLE);
            AggregationNode inner = p.aggregation(a -> a.addAggregation(totalPrice, (Expression)new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)new SymbolReference("totalprice"))), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE)).globalGrouping().source((PlanNode)p.project(Assignments.of((Symbol)totalPrice, (Expression)totalPrice.toSymbolReference()), (PlanNode)p.tableScan(new TableHandle(new ConnectorId("local"), (ConnectorTableHandle)new TpchTableHandle("local", "orders", 0.01)), (List<Symbol>)ImmutableList.of((Object)totalPrice), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)totalPrice, (Object)new TpchColumnHandle(totalPrice.getName(), (Type)DoubleType.DOUBLE))))));
            return p.aggregation(a -> a.addAggregation(p.symbol("sum_outer", (Type)DoubleType.DOUBLE), (Expression)new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)new SymbolReference("sum_inner"))), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE)).globalGrouping().source((PlanNode)inner));
        }).doesNotFire();
    }
}

