/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneIndexSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneIndexSourceColumns
extends BaseRuleTest {
    public TestPruneIndexSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneIndexSourceColumns()).on(p -> TestPruneIndexSourceColumns.buildProjectedIndexSource(p, symbol -> symbol.getName().equals("orderkey"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("orderkey")), PlanMatchPattern.constrainedIndexSource("orders", (Map<String, Domain>)ImmutableMap.of((Object)"totalprice", (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)), (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"totalprice", (Object)"totalprice"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneIndexSourceColumns()).on(p -> TestPruneIndexSourceColumns.buildProjectedIndexSource(p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    private static PlanNode buildProjectedIndexSource(PlanBuilder p, Predicate<Symbol> projectionFilter) {
        Symbol orderkey = p.symbol("orderkey", (Type)IntegerType.INTEGER);
        Symbol custkey = p.symbol("custkey", (Type)IntegerType.INTEGER);
        Symbol totalprice = p.symbol("totalprice", (Type)DoubleType.DOUBLE);
        TpchColumnHandle orderkeyHandle = new TpchColumnHandle(orderkey.getName(), (Type)IntegerType.INTEGER);
        TpchColumnHandle custkeyHandle = new TpchColumnHandle(custkey.getName(), (Type)IntegerType.INTEGER);
        TpchColumnHandle totalpriceHandle = new TpchColumnHandle(totalprice.getName(), (Type)DoubleType.DOUBLE);
        return p.project(Assignments.identity((Iterable)((Iterable)ImmutableList.of((Object)orderkey, (Object)custkey, (Object)totalprice).stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.indexSource(new TableHandle(new ConnectorId("local"), (ConnectorTableHandle)new TpchTableHandle("local", "orders", 0.01)), (Set<Symbol>)ImmutableSet.of((Object)orderkey, (Object)custkey), (List<Symbol>)ImmutableList.of((Object)orderkey, (Object)custkey, (Object)totalprice), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)orderkey, (Object)orderkeyHandle, (Object)custkey, (Object)custkeyHandle, (Object)totalprice, (Object)totalpriceHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)totalpriceHandle, (Object)NullableValue.asNull((Type)DoubleType.DOUBLE)))));
    }
}

