/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneLimitColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.testng.annotations.Test;

public class TestPruneLimitColumns
extends BaseRuleTest {
    public TestPruneLimitColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneLimitColumns()).on(p -> this.buildProjectedLimit((PlanBuilder)p, symbol -> symbol.getName().equals("b"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.limit(1L, PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneLimitColumns()).on(p -> this.buildProjectedLimit((PlanBuilder)p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    private ProjectNode buildProjectedLimit(PlanBuilder planBuilder, Predicate<Symbol> projectionFilter) {
        Symbol a = planBuilder.symbol("a");
        Symbol b = planBuilder.symbol("b");
        return planBuilder.project(Assignments.identity((Iterable)((Iterable)Stream.of(a, b).filter(projectionFilter).collect(ImmutableSet.toImmutableSet()))), (PlanNode)planBuilder.limit(1L, (PlanNode)planBuilder.values(a, b)));
    }
}

