/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneSemiJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneSemiJoinColumns
extends BaseRuleTest {
    public TestPruneSemiJoinColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testSemiJoinNotNeeded() {
        this.tester().assertThat((Rule)new PruneSemiJoinColumns()).on(p -> TestPruneSemiJoinColumns.buildProjectedSemiJoin(p, symbol -> symbol.getName().equals("leftValue"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftValue", (Object)PlanMatchPattern.expression("leftValue")), PlanMatchPattern.values("leftKey", "leftKeyHash", "leftValue")));
    }

    @Test
    public void testAllColumnsNeeded() {
        this.tester().assertThat((Rule)new PruneSemiJoinColumns()).on(p -> TestPruneSemiJoinColumns.buildProjectedSemiJoin(p, symbol -> true)).doesNotFire();
    }

    @Test
    public void testKeysNotNeeded() {
        this.tester().assertThat((Rule)new PruneSemiJoinColumns()).on(p -> TestPruneSemiJoinColumns.buildProjectedSemiJoin(p, symbol -> symbol.getName().equals("leftValue") || symbol.getName().equals("match"))).doesNotFire();
    }

    @Test
    public void testValueNotNeeded() {
        this.tester().assertThat((Rule)new PruneSemiJoinColumns()).on(p -> TestPruneSemiJoinColumns.buildProjectedSemiJoin(p, symbol -> symbol.getName().equals("match"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"match", (Object)PlanMatchPattern.expression("match")), PlanMatchPattern.semiJoin("leftKey", "rightKey", "match", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftKey", (Object)PlanMatchPattern.expression("leftKey"), (Object)"leftKeyHash", (Object)PlanMatchPattern.expression("leftKeyHash")), PlanMatchPattern.values("leftKey", "leftKeyHash", "leftValue")), PlanMatchPattern.values("rightKey"))));
    }

    private static PlanNode buildProjectedSemiJoin(PlanBuilder p, Predicate<Symbol> projectionFilter) {
        Symbol match = p.symbol("match");
        Symbol leftKey = p.symbol("leftKey");
        Symbol leftKeyHash = p.symbol("leftKeyHash");
        Symbol leftValue = p.symbol("leftValue");
        Symbol rightKey = p.symbol("rightKey");
        ImmutableList outputs = ImmutableList.of((Object)match, (Object)leftKey, (Object)leftKeyHash, (Object)leftValue);
        return p.project(Assignments.identity((Iterable)((Iterable)outputs.stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.semiJoin(leftKey, rightKey, match, Optional.of(leftKeyHash), Optional.empty(), (PlanNode)p.values(leftKey, leftKeyHash, leftValue), (PlanNode)p.values(rightKey)));
    }
}

