/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneTableScanColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneTableScanColumns
extends BaseRuleTest {
    public TestPruneTableScanColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneTableScanColumns()).on(p -> {
            Symbol orderdate = p.symbol("orderdate", (Type)DateType.DATE);
            Symbol totalprice = p.symbol("totalprice", (Type)DoubleType.DOUBLE);
            return p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)totalprice.toSymbolReference()), (PlanNode)p.tableScan(new TableHandle(new ConnectorId("local"), (ConnectorTableHandle)new TpchTableHandle("local", "orders", 0.01)), (List<Symbol>)ImmutableList.of((Object)orderdate, (Object)totalprice), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)orderdate, (Object)new TpchColumnHandle(orderdate.getName(), (Type)DateType.DATE), (Object)totalprice, (Object)new TpchColumnHandle(totalprice.getName(), (Type)DoubleType.DOUBLE))));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x_", (Object)PlanMatchPattern.expression("totalprice_")), PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice_", (Object)"totalprice"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneTableScanColumns()).on(p -> p.project(Assignments.of((Symbol)p.symbol("y"), (Expression)PlanBuilder.expression("x")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("x")), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("x"), (Object)new TestingMetadata.TestingColumnHandle("x"))))).doesNotFire();
    }
}

