/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughProject;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushLimitThroughProject
extends BaseRuleTest {
    public TestPushLimitThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownLimitNonIdentityProjection() {
        this.tester().assertThat((Rule)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(new Symbol[0])));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.limit(1L, PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testDoesntPushdownLimitThroughIdentityProjection() {
        this.tester().assertThat((Rule)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

