/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushProjectionThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushProjectionThroughUnion
extends BaseRuleTest {
    public TestPushProjectionThroughUnion() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule)new PushProjectionThroughUnion()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new LongLiteral("3")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule)new PushProjectionThroughUnion()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol cTimes3 = p.symbol("c_times_3");
            return p.project(Assignments.of((Symbol)cTimes3, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)c.toSymbolReference(), (Expression)new LongLiteral("3"))), (PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(a), (Object)p.values(b))));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_times_3", (Object)PlanMatchPattern.expression("a * 3")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_times_3", (Object)PlanMatchPattern.expression("b * 3")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b")))).withNumberOfOutputColumns(1).withAlias("a_times_3").withAlias("b_times_3"));
    }
}

