/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ReorderJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestReorderJoins {
    private RuleTester tester;
    private static final ImmutableList<List<Expression>> TWO_ROWS = ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of());

    @BeforeClass
    public void setUp() {
        this.tester = new RuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of((Object)"join_distribution_type", (Object)FeaturesConfig.JoinDistributionType.AUTOMATIC.name(), (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.AUTOMATIC.name()), Optional.of(4));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    @Test
    public void testKeepsOutputSymbols() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("A2")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A2")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(5000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0), (Object)new Symbol("A2"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).withExactOutputs("A2"));
    }

    @Test
    public void testReplicatesAndFlipsWhenOneTableMuchSmaller() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionsWhenRequiredBySession() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1")), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionsWhenBothTablesEqual() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatesWhenRequiredBySession() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1")), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatedScalarJoinEvenWhereSessionRequiresRepartitioned() {
        PlanMatchPattern expectedPlan = PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)));
        PlanNodeStatsEstimate valuesA = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        PlanNodeStatsEstimate valuesB = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1")), Optional.empty())).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).matches(expectedPlan);
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesA"), p.symbol("A1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1")), Optional.empty())).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).matches(expectedPlan);
    }

    @Test
    public void testDoesNotFireForCrossJoin() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoStats() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.UNKNOWN_STATS).doesNotFire();
    }

    @Test
    public void testDoesNotFireForNonDeterministicFilter() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1")), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)p.symbol("A1").toSymbolReference(), (Expression)new FunctionCall(QualifiedName.of((String)"random"), (List)ImmutableList.of()))))).doesNotFire();
    }

    @Test
    public void testPredicatesPushedDown() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1"), (Object)p.symbol("B2")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1"), (Object)p.symbol("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), (List<Symbol>)ImmutableList.of((Object)p.symbol("C1")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("B2"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)p.symbol("A1").toSymbolReference(), (Expression)p.symbol("B1").toSymbolReference())))).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(5.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0), (Object)new Symbol("B2"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "B2")), PlanMatchPattern.values("C1"), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), PlanMatchPattern.values("A1"), PlanMatchPattern.values("B1", "B2"))));
    }

    @Test
    public void testSmallerJoinFirst() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1"), (Object)p.symbol("B2")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1"), (Object)p.symbol("B1"), (Object)p.symbol("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), (List<Symbol>)ImmutableList.of((Object)p.symbol("C1")), (List<List<Expression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("B2"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)p.symbol("A1").toSymbolReference(), (Expression)p.symbol("B1").toSymbolReference())))).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(40.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0), (Object)new Symbol("B2"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(99.0, 199.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), PlanMatchPattern.values("A1"), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "B2")), PlanMatchPattern.values("C1"), PlanMatchPattern.values("B1", "B2"))));
    }

    private RuleAssert assertReorderJoins() {
        return this.tester.assertThat((Rule)new ReorderJoins(new CostComparator(1.0, 1.0, 1.0)));
    }
}

