/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.GatherAndMergeWindows;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSwapAdjacentWindowsBySpecifications
extends BaseRuleTest {
    private WindowNode.Frame frame = new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty());
    private Signature signature = new Signature("avg", FunctionKind.WINDOW, (List)ImmutableList.of(), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()), false);

    public TestSwapAdjacentWindowsBySpecifications() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutWindowFunctions() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnPlanWithSingleWindowNode() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)new WindowNode.Function(new FunctionCall(QualifiedName.of((String)"avg"), (List)ImmutableList.of()), this.signature, this.frame)), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void subsetComesFirst() {
        String columnAAlias = "ALIAS_A";
        String columnBAlias = "ALIAS_B";
        ExpectedValueProvider<WindowNode.Specification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)columnAAlias), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());
        ExpectedValueProvider<WindowNode.Specification> specificationAB = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)columnAAlias, (Object)columnBAlias), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());
        Optional<Window> windowAB = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new SymbolReference("b")), Optional.empty(), Optional.empty()));
        Optional<Window> windowA = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()));
        this.tester().assertThat((Rule)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1", (Type)DoubleType.DOUBLE), (Object)new WindowNode.Function(new FunctionCall(QualifiedName.of((String)"avg"), windowA, false, (List)ImmutableList.of((Object)new SymbolReference("a"))), this.signature, this.frame)), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2", (Type)DoubleType.DOUBLE), (Object)new WindowNode.Function(new FunctionCall(QualifiedName.of((String)"avg"), windowAB, false, (List)ImmutableList.of((Object)new SymbolReference("b"))), this.signature, this.frame)), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).matches(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationAB).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnBAlias))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)columnAAlias, (Object)0, (Object)columnBAlias, (Object)1)))));
    }

    @Test
    public void dependentWindowsAreNotReordered() {
        Optional<Window> windowA = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()));
        this.tester().assertThat((Rule)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)new WindowNode.Function(new FunctionCall(QualifiedName.of((String)"avg"), windowA, false, (List)ImmutableList.of((Object)new SymbolReference("avg_2"))), this.signature, this.frame)), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)new WindowNode.Function(new FunctionCall(QualifiedName.of((String)"avg"), windowA, false, (List)ImmutableList.of((Object)new SymbolReference("a"))), this.signature, this.frame)), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).doesNotFire();
    }
}

