/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedScalarAggregationToJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestTransformCorrelatedScalarAggregationToJoin
extends BaseRuleTest {
    public TestTransformCorrelatedScalarAggregationToJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutApplyNode() {
        this.tester().assertThat((Rule)new TransformCorrelatedScalarAggregationToJoin(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithoutAggregation() {
        this.tester().assertThat((Rule)new TransformCorrelatedScalarAggregationToJoin(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.lateral((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule)new TransformCorrelatedScalarAggregationToJoin(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.lateral((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithNonScalarAggregation() {
        this.tester().assertThat((Rule)new TransformCorrelatedScalarAggregationToJoin(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.lateral((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithoutProjection() {
        this.tester().assertThat((Rule)new TransformCorrelatedScalarAggregationToJoin(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.lateral((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sum_1", (Object)PlanMatchPattern.expression("sum_1"), (Object)"corr", (Object)PlanMatchPattern.expression("corr")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sum_1", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1)))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjection() {
        this.tester().assertThat((Rule)new TransformCorrelatedScalarAggregationToJoin(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.lateral((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr"), (Expression)PlanBuilder.expression("sum + 1")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping())))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"expr", (Object)PlanMatchPattern.expression("(\"sum_1\" + 1)")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sum_1", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1)))))));
    }
}

