/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestTransformCorrelatedSingleRowSubqueryToProject
extends BaseRuleTest {
    public TestTransformCorrelatedSingleRowSubqueryToProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void testRewrite() {
        this.tester().assertThat((Rule)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.lateral((List<Symbol>)ImmutableList.of((Object)p.symbol("l_nationkey")), (PlanNode)p.tableScan(new TableHandle(new ConnectorId("local"), (ConnectorTableHandle)new TpchTableHandle("local", "nation", 0.01)), (List<Symbol>)ImmutableList.of((Object)p.symbol("l_nationkey")), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("l_nationkey"), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("l_expr2"), (Expression)PlanBuilder.expression("l_nationkey + 1")), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_expr2", (Object)PlanMatchPattern.expression("l_nationkey + 1"), (Object)"l_nationkey", (Object)PlanMatchPattern.expression("l_nationkey")), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"l_nationkey", (Object)"nationkey"))));
    }

    @Test
    public void testDoesNotFireWithEmptyValuesNode() {
        this.tester().assertThat((Rule)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.lateral((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }
}

