/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.TransformExistsApplyToLateralNode;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestTransformExistsApplyToLateralJoin
extends BaseRuleTest {
    public TestTransformExistsApplyToLateralJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule)new TransformExistsApplyToLateralNode(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.values(p.symbol("a"))).doesNotFire();
        this.tester().assertThat((Rule)new TransformExistsApplyToLateralNode(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.lateral((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testRewrite() {
        this.tester().assertThat((Rule)new TransformExistsApplyToLateralNode(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.apply(Assignments.of((Symbol)p.symbol("b", (Type)BooleanType.BOOLEAN), (Expression)PlanBuilder.expression("EXISTS(SELECT TRUE)")), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.lateral((List<String>)ImmutableList.of(), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("(\"count_expr\" > CAST(0 AS bigint))")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_expr", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values(new String[0])))));
    }

    @Test
    public void testRewritesToLimit() {
        this.tester().assertThat((Rule)new TransformExistsApplyToLateralNode(this.tester().getMetadata().getFunctionRegistry())).on(p -> p.apply(Assignments.of((Symbol)p.symbol("b", (Type)BooleanType.BOOLEAN), (Expression)PlanBuilder.expression("EXISTS(SELECT TRUE)")), (List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of(), (PlanNode)p.filter(PlanBuilder.expression("corr = column"), (PlanNode)p.values(p.symbol("column")))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("COALESCE(subquerytrue, false)")), PlanMatchPattern.lateral((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.values("corr"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"subquerytrue", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.limit(1L, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("column"))))))));
    }
}

