/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import java.util.Collections;
import org.testng.annotations.Test;

public class TestTransformUncorrelatedInPredicateSubqueryToSemiJoin
extends BaseRuleTest {
    public TestTransformUncorrelatedInPredicateSubqueryToSemiJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNoCorrelation() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply(Assignments.of(), Collections.emptyList(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnNonInPredicateSubquery() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply(Assignments.of((Symbol)p.symbol("x"), (Expression)new ExistsPredicate((Expression)new LongLiteral("1"))), Collections.emptyList(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testFiresForInPredicate() {
        this.tester().assertThat((Rule)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply(Assignments.of((Symbol)p.symbol("x"), (Expression)new InPredicate((Expression)new SymbolReference("y"), (Expression)new SymbolReference("z"))), Collections.emptyList(), (PlanNode)p.values(p.symbol("y")), (PlanNode)p.values(p.symbol("z")))).matches(PlanMatchPattern.node(SemiJoinNode.class, PlanMatchPattern.values("y"), PlanMatchPattern.values("z")));
    }
}

