/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule.test;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.IndexHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TestingConnectorIndexHandle;
import com.facebook.presto.sql.planner.TestingConnectorTransactionHandle;
import com.facebook.presto.sql.planner.TestingWriterTarget;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.util.MoreLists;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class PlanBuilder {
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Map<Symbol, Type> symbols = new HashMap<Symbol, Type>();

    public PlanBuilder(PlanNodeIdAllocator idAllocator, Metadata metadata) {
        this.idAllocator = idAllocator;
        this.metadata = metadata;
    }

    public OutputNode output(List<String> columnNames, List<Symbol> outputs, PlanNode source) {
        return new OutputNode(this.idAllocator.getNextId(), source, columnNames, outputs);
    }

    public OutputNode output(Consumer<OutputBuilder> outputBuilderConsumer) {
        OutputBuilder outputBuilder = new OutputBuilder();
        outputBuilderConsumer.accept(outputBuilder);
        return outputBuilder.build();
    }

    public ValuesNode values(Symbol ... columns) {
        return this.values(this.idAllocator.getNextId(), columns);
    }

    public ValuesNode values(PlanNodeId id, Symbol ... columns) {
        return this.values(id, 0, columns);
    }

    public ValuesNode values(PlanNodeId id, int rows, Symbol ... columns) {
        return this.values(id, (List<Symbol>)ImmutableList.copyOf((Object[])columns), MoreLists.nElements((int)rows, row -> MoreLists.nElements((int)columns.length, cell -> new NullLiteral())));
    }

    public ValuesNode values(List<Symbol> columns, List<List<Expression>> rows) {
        return this.values(this.idAllocator.getNextId(), columns, rows);
    }

    public ValuesNode values(PlanNodeId id, List<Symbol> columns, List<List<Expression>> rows) {
        return new ValuesNode(id, columns, rows);
    }

    public EnforceSingleRowNode enforceSingleRow(PlanNode source) {
        return new EnforceSingleRowNode(this.idAllocator.getNextId(), source);
    }

    public LimitNode limit(long limit, PlanNode source) {
        return new LimitNode(this.idAllocator.getNextId(), source, limit, false);
    }

    public TopNNode topN(long count, List<Symbol> orderBy, PlanNode source) {
        return new TopNNode(this.idAllocator.getNextId(), source, count, new OrderingScheme(orderBy, (Map)Maps.toMap(orderBy, (Function)Functions.constant((Object)SortOrder.ASC_NULLS_FIRST))), TopNNode.Step.SINGLE);
    }

    public SampleNode sample(double sampleRatio, SampleNode.Type type, PlanNode source) {
        return new SampleNode(this.idAllocator.getNextId(), source, sampleRatio, type);
    }

    public ProjectNode project(Assignments assignments, PlanNode source) {
        return new ProjectNode(this.idAllocator.getNextId(), source, assignments);
    }

    public MarkDistinctNode markDistinct(Symbol markerSymbol, List<Symbol> distinctSymbols, PlanNode source) {
        return new MarkDistinctNode(this.idAllocator.getNextId(), source, markerSymbol, distinctSymbols, Optional.empty());
    }

    public MarkDistinctNode markDistinct(Symbol markerSymbol, List<Symbol> distinctSymbols, Symbol hashSymbol, PlanNode source) {
        return new MarkDistinctNode(this.idAllocator.getNextId(), source, markerSymbol, distinctSymbols, Optional.of(hashSymbol));
    }

    public FilterNode filter(Expression predicate, PlanNode source) {
        return new FilterNode(this.idAllocator.getNextId(), source, predicate);
    }

    public AggregationNode aggregation(Consumer<AggregationBuilder> aggregationBuilderConsumer) {
        AggregationBuilder aggregationBuilder = new AggregationBuilder();
        aggregationBuilderConsumer.accept(aggregationBuilder);
        return aggregationBuilder.build();
    }

    public ApplyNode apply(Assignments subqueryAssignments, List<Symbol> correlation, PlanNode input, PlanNode subquery) {
        NullLiteral originSubquery = new NullLiteral();
        return new ApplyNode(this.idAllocator.getNextId(), input, subquery, subqueryAssignments, correlation, (Node)originSubquery);
    }

    public AssignUniqueId assignUniqueId(Symbol unique, PlanNode source) {
        return new AssignUniqueId(this.idAllocator.getNextId(), source, unique);
    }

    public LateralJoinNode lateral(List<Symbol> correlation, PlanNode input, PlanNode subquery) {
        NullLiteral originSubquery = new NullLiteral();
        return new LateralJoinNode(this.idAllocator.getNextId(), input, subquery, correlation, LateralJoinNode.Type.INNER, (Node)originSubquery);
    }

    public TableScanNode tableScan(List<Symbol> symbols, Map<Symbol, ColumnHandle> assignments) {
        TableHandle tableHandle = new TableHandle(new ConnectorId("testConnector"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle());
        return this.tableScan(tableHandle, symbols, assignments, Optional.empty(), (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<Symbol> symbols, Map<Symbol, ColumnHandle> assignments) {
        return this.tableScan(tableHandle, symbols, assignments, Optional.empty());
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<Symbol> symbols, Map<Symbol, ColumnHandle> assignments, Optional<TableLayoutHandle> tableLayout) {
        return this.tableScan(tableHandle, symbols, assignments, tableLayout, (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<Symbol> symbols, Map<Symbol, ColumnHandle> assignments, Optional<TableLayoutHandle> tableLayout, TupleDomain<ColumnHandle> tupleDomain) {
        return new TableScanNode(this.idAllocator.getNextId(), tableHandle, symbols, assignments, tableLayout, tupleDomain);
    }

    public TableFinishNode tableDelete(SchemaTableName schemaTableName, PlanNode deleteSource, Symbol deleteRowId) {
        TableWriterNode.DeleteHandle deleteHandle = new TableWriterNode.DeleteHandle(new TableHandle(new ConnectorId("testConnector"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle()), schemaTableName);
        return new TableFinishNode(this.idAllocator.getNextId(), (PlanNode)this.exchange(e -> e.addSource((PlanNode)new DeleteNode(this.idAllocator.getNextId(), deleteSource, deleteHandle, deleteRowId, (List)ImmutableList.of((Object)deleteRowId))).addInputsSet(deleteRowId).singleDistributionPartitioningScheme(deleteRowId)), (TableWriterNode.WriterTarget)deleteHandle, deleteRowId, Optional.empty(), Optional.empty());
    }

    public ExchangeNode gatheringExchange(ExchangeNode.Scope scope, PlanNode child) {
        return this.exchange(builder -> builder.type(ExchangeNode.Type.GATHER).scope(scope).singleDistributionPartitioningScheme(child.getOutputSymbols()).addSource(child).addInputsSet(child.getOutputSymbols()));
    }

    public SemiJoinNode semiJoin(Symbol sourceJoinSymbol, Symbol filteringSourceJoinSymbol, Symbol semiJoinOutput, Optional<Symbol> sourceHashSymbol, Optional<Symbol> filteringSourceHashSymbol, PlanNode source, PlanNode filteringSource) {
        return this.semiJoin(source, filteringSource, sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutput, sourceHashSymbol, filteringSourceHashSymbol, Optional.empty());
    }

    public SemiJoinNode semiJoin(PlanNode source, PlanNode filteringSource, Symbol sourceJoinSymbol, Symbol filteringSourceJoinSymbol, Symbol semiJoinOutput, Optional<Symbol> sourceHashSymbol, Optional<Symbol> filteringSourceHashSymbol, Optional<SemiJoinNode.DistributionType> distributionType) {
        return new SemiJoinNode(this.idAllocator.getNextId(), source, filteringSource, sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutput, sourceHashSymbol, filteringSourceHashSymbol, distributionType);
    }

    public IndexSourceNode indexSource(TableHandle tableHandle, Set<Symbol> lookupSymbols, List<Symbol> outputSymbols, Map<Symbol, ColumnHandle> assignments, TupleDomain<ColumnHandle> effectiveTupleDomain) {
        return new IndexSourceNode(this.idAllocator.getNextId(), new IndexHandle(tableHandle.getConnectorId(), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, (ConnectorIndexHandle)TestingConnectorIndexHandle.INSTANCE), tableHandle, Optional.empty(), lookupSymbols, outputSymbols, assignments, effectiveTupleDomain);
    }

    public ExchangeNode exchange(Consumer<ExchangeBuilder> exchangeBuilderConsumer) {
        ExchangeBuilder exchangeBuilder = new ExchangeBuilder();
        exchangeBuilderConsumer.accept(exchangeBuilder);
        return exchangeBuilder.build();
    }

    public JoinNode join(JoinNode.Type joinType, PlanNode left, PlanNode right, JoinNode.EquiJoinClause ... criteria) {
        return this.join(joinType, left, right, Optional.empty(), criteria);
    }

    public JoinNode join(JoinNode.Type joinType, PlanNode left, PlanNode right, Expression filter, JoinNode.EquiJoinClause ... criteria) {
        return this.join(joinType, left, right, Optional.of(filter), criteria);
    }

    private JoinNode join(JoinNode.Type joinType, PlanNode left, PlanNode right, Optional<Expression> filter, JoinNode.EquiJoinClause ... criteria) {
        return this.join(joinType, left, right, (List<JoinNode.EquiJoinClause>)ImmutableList.copyOf((Object[])criteria), (List<Symbol>)ImmutableList.builder().addAll((Iterable)left.getOutputSymbols()).addAll((Iterable)right.getOutputSymbols()).build(), filter, Optional.empty(), Optional.empty());
    }

    public JoinNode join(JoinNode.Type type, PlanNode left, PlanNode right, List<JoinNode.EquiJoinClause> criteria, List<Symbol> outputSymbols, Optional<Expression> filter) {
        return this.join(type, left, right, criteria, outputSymbols, filter, Optional.empty(), Optional.empty());
    }

    public JoinNode join(JoinNode.Type type, PlanNode left, PlanNode right, List<JoinNode.EquiJoinClause> criteria, List<Symbol> outputSymbols, Optional<Expression> filter, Optional<Symbol> leftHashSymbol, Optional<Symbol> rightHashSymbol) {
        return this.join(type, left, right, criteria, outputSymbols, filter, leftHashSymbol, rightHashSymbol, Optional.empty());
    }

    public JoinNode join(JoinNode.Type type, PlanNode left, PlanNode right, List<JoinNode.EquiJoinClause> criteria, List<Symbol> outputSymbols, Optional<Expression> filter, Optional<Symbol> leftHashSymbol, Optional<Symbol> rightHashSymbol, Optional<JoinNode.DistributionType> distributionType) {
        return new JoinNode(this.idAllocator.getNextId(), type, left, right, criteria, outputSymbols, filter, leftHashSymbol, rightHashSymbol, distributionType);
    }

    public PlanNode indexJoin(IndexJoinNode.Type type, TableScanNode probe, TableScanNode index) {
        return new IndexJoinNode(this.idAllocator.getNextId(), type, (PlanNode)probe, (PlanNode)index, Collections.emptyList(), Optional.empty(), Optional.empty());
    }

    public UnionNode union(ListMultimap<Symbol, Symbol> outputsToInputs, List<PlanNode> sources) {
        ImmutableList outputs = (ImmutableList)outputsToInputs.keySet().stream().collect(ImmutableList.toImmutableList());
        return new UnionNode(this.idAllocator.getNextId(), sources, outputsToInputs, (List)outputs);
    }

    public TableWriterNode tableWriter(List<Symbol> columns, List<String> columnNames, PlanNode source) {
        return new TableWriterNode(this.idAllocator.getNextId(), source, (TableWriterNode.WriterTarget)new TestingWriterTarget(), this.symbol("partialrows", (Type)BigintType.BIGINT), this.symbol("fragment", (Type)VarbinaryType.VARBINARY), columns, columnNames, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Symbol symbol(String name) {
        return this.symbol(name, (Type)BigintType.BIGINT);
    }

    public Symbol symbol(String name, Type type) {
        Symbol symbol = new Symbol(name);
        Type old = this.symbols.put(symbol, type);
        if (old != null && !old.equals(type)) {
            throw new IllegalArgumentException(String.format("Symbol '%s' already registered with type '%s'", name, old));
        }
        if (old == null) {
            this.symbols.put(symbol, type);
        }
        return symbol;
    }

    public WindowNode window(WindowNode.Specification specification, Map<Symbol, WindowNode.Function> functions, PlanNode source) {
        return new WindowNode(this.idAllocator.getNextId(), source, specification, (Map)ImmutableMap.copyOf(functions), Optional.empty(), (Set)ImmutableSet.of(), 0);
    }

    public WindowNode window(WindowNode.Specification specification, Map<Symbol, WindowNode.Function> functions, Symbol hashSymbol, PlanNode source) {
        return new WindowNode(this.idAllocator.getNextId(), source, specification, (Map)ImmutableMap.copyOf(functions), Optional.of(hashSymbol), (Set)ImmutableSet.of(), 0);
    }

    public RemoteSourceNode remoteSourceNode(List<PlanFragmentId> fragmentIds, List<Symbol> symbols, ExchangeNode.Type exchangeType) {
        return new RemoteSourceNode(this.idAllocator.getNextId(), fragmentIds, symbols, Optional.empty(), exchangeType);
    }

    public static Expression expression(String sql) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql));
    }

    public static List<Expression> expressions(String ... expressions) {
        return (List)Stream.of(expressions).map(PlanBuilder::expression).collect(ImmutableList.toImmutableList());
    }

    public TypeProvider getTypes() {
        return TypeProvider.copyOf(this.symbols);
    }

    public class ExchangeBuilder {
        private ExchangeNode.Type type = ExchangeNode.Type.GATHER;
        private ExchangeNode.Scope scope = ExchangeNode.Scope.REMOTE;
        private PartitioningScheme partitioningScheme;
        private OrderingScheme orderingScheme;
        private List<PlanNode> sources = new ArrayList<PlanNode>();
        private List<List<Symbol>> inputs = new ArrayList<List<Symbol>>();

        public ExchangeBuilder type(ExchangeNode.Type type) {
            this.type = type;
            return this;
        }

        public ExchangeBuilder scope(ExchangeNode.Scope scope) {
            this.scope = scope;
            return this;
        }

        public ExchangeBuilder singleDistributionPartitioningScheme(Symbol ... outputSymbols) {
            return this.singleDistributionPartitioningScheme(Arrays.asList(outputSymbols));
        }

        public ExchangeBuilder singleDistributionPartitioningScheme(List<Symbol> outputSymbols) {
            return this.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), outputSymbols));
        }

        public ExchangeBuilder fixedHashDistributionParitioningScheme(List<Symbol> outputSymbols, List<Symbol> partitioningSymbols) {
            return this.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List)ImmutableList.copyOf(partitioningSymbols)), (List)ImmutableList.copyOf(outputSymbols)));
        }

        public ExchangeBuilder fixedHashDistributionParitioningScheme(List<Symbol> outputSymbols, List<Symbol> partitioningSymbols, Symbol hashSymbol) {
            return this.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List)ImmutableList.copyOf(partitioningSymbols)), (List)ImmutableList.copyOf(outputSymbols), Optional.of(hashSymbol)));
        }

        public ExchangeBuilder partitioningScheme(PartitioningScheme partitioningScheme) {
            this.partitioningScheme = partitioningScheme;
            return this;
        }

        public ExchangeBuilder addSource(PlanNode source) {
            this.sources.add(source);
            return this;
        }

        public ExchangeBuilder addInputsSet(Symbol ... inputs) {
            return this.addInputsSet(Arrays.asList(inputs));
        }

        public ExchangeBuilder addInputsSet(List<Symbol> inputs) {
            this.inputs.add(inputs);
            return this;
        }

        public ExchangeBuilder orderingScheme(OrderingScheme orderingScheme) {
            this.orderingScheme = orderingScheme;
            return this;
        }

        protected ExchangeNode build() {
            return new ExchangeNode(PlanBuilder.this.idAllocator.getNextId(), this.type, this.scope, this.partitioningScheme, this.sources, this.inputs, Optional.ofNullable(this.orderingScheme));
        }
    }

    public class AggregationBuilder {
        private PlanNode source;
        private Map<Symbol, AggregationNode.Aggregation> assignments = new HashMap<Symbol, AggregationNode.Aggregation>();
        private AggregationNode.GroupingSetDescriptor groupingSets;
        private List<Symbol> preGroupedSymbols = new ArrayList<Symbol>();
        private AggregationNode.Step step = AggregationNode.Step.SINGLE;
        private Optional<Symbol> hashSymbol = Optional.empty();
        private Optional<Symbol> groupIdSymbol = Optional.empty();

        public AggregationBuilder source(PlanNode source) {
            this.source = source;
            return this;
        }

        public AggregationBuilder addAggregation(Symbol output, Expression expression, List<Type> inputTypes) {
            return this.addAggregation(output, expression, inputTypes, Optional.empty());
        }

        public AggregationBuilder addAggregation(Symbol output, Expression expression, List<Type> inputTypes, Symbol mask) {
            return this.addAggregation(output, expression, inputTypes, Optional.of(mask));
        }

        private AggregationBuilder addAggregation(Symbol output, Expression expression, List<Type> inputTypes, Optional<Symbol> mask) {
            Preconditions.checkArgument((boolean)(expression instanceof FunctionCall));
            FunctionCall aggregation = (FunctionCall)expression;
            Signature signature = PlanBuilder.this.metadata.getFunctionRegistry().resolveFunction(aggregation.getName(), TypeSignatureProvider.fromTypes(inputTypes));
            return this.addAggregation(output, new AggregationNode.Aggregation(aggregation, signature, mask));
        }

        public AggregationBuilder addAggregation(Symbol output, AggregationNode.Aggregation aggregation) {
            this.assignments.put(output, aggregation);
            return this;
        }

        public AggregationBuilder globalGrouping() {
            this.groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.of()));
            return this;
        }

        public AggregationBuilder singleGroupingSet(Symbol ... symbols) {
            this.groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.copyOf((Object[])symbols)));
            return this;
        }

        public AggregationBuilder groupingSets(AggregationNode.GroupingSetDescriptor groupingSets) {
            Preconditions.checkState((this.groupingSets == null ? 1 : 0) != 0, (Object)"groupingSets already defined");
            this.groupingSets = groupingSets;
            return this;
        }

        public AggregationBuilder preGroupedSymbols(Symbol ... symbols) {
            Preconditions.checkState((boolean)this.preGroupedSymbols.isEmpty(), (Object)"preGroupedSymbols already defined");
            this.preGroupedSymbols = ImmutableList.copyOf((Object[])symbols);
            return this;
        }

        public AggregationBuilder step(AggregationNode.Step step) {
            this.step = step;
            return this;
        }

        public AggregationBuilder hashSymbol(Symbol hashSymbol) {
            this.hashSymbol = Optional.of(hashSymbol);
            return this;
        }

        public AggregationBuilder groupIdSymbol(Symbol groupIdSymbol) {
            this.groupIdSymbol = Optional.of(groupIdSymbol);
            return this;
        }

        protected AggregationNode build() {
            Preconditions.checkState((this.groupingSets != null ? 1 : 0) != 0, (Object)"No grouping sets defined; use globalGrouping/groupingKeys method");
            return new AggregationNode(PlanBuilder.this.idAllocator.getNextId(), this.source, this.assignments, this.groupingSets, this.preGroupedSymbols, this.step, this.hashSymbol, this.groupIdSymbol);
        }
    }

    public class OutputBuilder {
        private PlanNode source;
        private List<String> columnNames = new ArrayList<String>();
        private List<Symbol> outputs = new ArrayList<Symbol>();

        public OutputBuilder source(PlanNode source) {
            this.source = source;
            return this;
        }

        public OutputBuilder column(Symbol symbol) {
            return this.column(symbol, symbol.getName());
        }

        public OutputBuilder column(Symbol symbol, String columnName) {
            this.outputs.add(symbol);
            this.columnNames.add(columnName);
            return this;
        }

        protected OutputNode build() {
            return new OutputNode(PlanBuilder.this.idAllocator.getNextId(), this.source, this.columnNames, this.outputs);
        }
    }
}

