/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule.test;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Match;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Memo;
import com.facebook.presto.sql.planner.iterative.PlanNodeMatcher;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.testng.Assert;

public class RuleAssert {
    private final Metadata metadata;
    private TestingStatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private Session session;
    private final Rule<?> rule;
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private TypeProvider types;
    private PlanNode plan;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;

    public RuleAssert(Metadata metadata, StatsCalculator statsCalculator, CostCalculator costCalculator, Session session, Rule rule, TransactionManager transactionManager, AccessControl accessControl) {
        this.metadata = metadata;
        this.statsCalculator = new TestingStatsCalculator(statsCalculator);
        this.costCalculator = costCalculator;
        this.session = session;
        this.rule = rule;
        this.transactionManager = transactionManager;
        this.accessControl = accessControl;
    }

    public RuleAssert setSystemProperty(String key, String value) {
        return this.withSession(Session.builder((Session)this.session).setSystemProperty(key, value).build());
    }

    public RuleAssert withSession(Session session) {
        this.session = session;
        return this;
    }

    public RuleAssert overrideStats(String nodeId, PlanNodeStatsEstimate nodeStats) {
        this.statsCalculator.setNodeStats(new PlanNodeId(nodeId), nodeStats);
        return this;
    }

    public RuleAssert on(Function<PlanBuilder, PlanNode> planProvider) {
        Preconditions.checkArgument((this.plan == null ? 1 : 0) != 0, (Object)"plan has already been set");
        PlanBuilder builder = new PlanBuilder(this.idAllocator, this.metadata);
        this.plan = planProvider.apply(builder);
        this.types = builder.getTypes();
        return this;
    }

    public void doesNotFire() {
        RuleApplication ruleApplication = this.applyRule();
        if (ruleApplication.wasRuleApplied()) {
            Assert.fail((String)String.format("Expected %s to not fire for:\n%s", this.rule.getClass().getName(), this.inTransaction(session -> PlanPrinter.textLogicalPlan((PlanNode)this.plan, (TypeProvider)ruleApplication.types, (FunctionRegistry)this.metadata.getFunctionRegistry(), (StatsProvider)ruleApplication.statsProvider, node -> PlanNodeCostEstimate.UNKNOWN_COST, (Session)session, (int)2))));
        }
    }

    public void matches(PlanMatchPattern pattern) {
        PlanNode actual;
        RuleApplication ruleApplication = this.applyRule();
        TypeProvider types = ruleApplication.types;
        if (!ruleApplication.wasRuleApplied()) {
            Assert.fail((String)String.format("%s did not fire for:\n%s", this.rule.getClass().getName(), this.formatPlan(this.plan, types)));
        }
        if ((actual = ruleApplication.getTransformedPlan()) == this.plan) {
            Assert.fail((String)String.format("%s: rule fired but return the original plan:\n%s", this.rule.getClass().getName(), this.formatPlan(this.plan, types)));
        }
        if (!ImmutableSet.copyOf((Collection)this.plan.getOutputSymbols()).equals((Object)ImmutableSet.copyOf((Collection)actual.getOutputSymbols()))) {
            Assert.fail((String)String.format("%s: output schema of transformed and original plans are not equivalent\n\texpected: %s\n\tactual:   %s", this.rule.getClass().getName(), this.plan.getOutputSymbols(), actual.getOutputSymbols()));
        }
        this.inTransaction(session -> {
            PlanAssert.assertPlan(session, this.metadata, ruleApplication.statsProvider, new Plan(actual, types), ruleApplication.lookup, pattern);
            return null;
        });
    }

    private RuleApplication applyRule() {
        SymbolAllocator symbolAllocator = new SymbolAllocator(this.types.allTypes());
        Memo memo = new Memo(this.idAllocator, this.plan);
        Lookup lookup = Lookup.from(planNode -> Stream.of(memo.resolve(planNode)));
        PlanNode memoRoot = memo.getNode(memo.getRootGroup());
        return this.inTransaction(session -> RuleAssert.applyRule(this.rule, memoRoot, this.ruleContext(this.statsCalculator, this.costCalculator, symbolAllocator, memo, lookup, (Session)session)));
    }

    private static <T> RuleApplication applyRule(Rule<T> rule, PlanNode planNode, Rule.Context context) {
        PlanNodeMatcher matcher = new PlanNodeMatcher(context.getLookup());
        Match match = matcher.match(rule.getPattern(), (Object)planNode);
        Rule.Result result = !rule.isEnabled(context.getSession()) || match.isEmpty() ? Rule.Result.empty() : rule.apply(match.value(), match.captures(), context);
        return new RuleApplication(context.getLookup(), context.getStatsProvider(), context.getSymbolAllocator().getTypes(), result);
    }

    private String formatPlan(PlanNode plan, TypeProvider types) {
        return this.inTransaction(session -> PlanPrinter.textLogicalPlan((PlanNode)plan, (TypeProvider)types, (FunctionRegistry)this.metadata.getFunctionRegistry(), (StatsCalculator)this.statsCalculator, (CostCalculator)this.costCalculator, (Session)session, (int)2, (boolean)false));
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    private Rule.Context ruleContext(StatsCalculator statsCalculator, CostCalculator costCalculator, final SymbolAllocator symbolAllocator, Memo memo, final Lookup lookup, final Session session) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, Optional.of(memo), lookup, session, symbolAllocator.getTypes());
        CachingCostProvider costProvider = new CachingCostProvider(costCalculator, (StatsProvider)statsProvider, Optional.of(memo), lookup, session, symbolAllocator.getTypes());
        return new Rule.Context((StatsProvider)statsProvider, (CostProvider)costProvider){
            final /* synthetic */ StatsProvider val$statsProvider;
            final /* synthetic */ CostProvider val$costProvider;
            {
                this.val$statsProvider = statsProvider;
                this.val$costProvider = costProvider;
            }

            public Lookup getLookup() {
                return lookup;
            }

            public PlanNodeIdAllocator getIdAllocator() {
                return RuleAssert.this.idAllocator;
            }

            public SymbolAllocator getSymbolAllocator() {
                return symbolAllocator;
            }

            public Session getSession() {
                return session;
            }

            public StatsProvider getStatsProvider() {
                return this.val$statsProvider;
            }

            public CostProvider getCostProvider() {
                return this.val$costProvider;
            }

            public void checkTimeoutNotExhausted() {
            }
        };
    }

    private static class TestingStatsCalculator
    implements StatsCalculator {
        private final StatsCalculator delegate;
        private final Map<PlanNodeId, PlanNodeStatsEstimate> stats = new HashMap<PlanNodeId, PlanNodeStatsEstimate>();

        TestingStatsCalculator(StatsCalculator delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
            if (this.stats.containsKey(node.getId())) {
                return this.stats.get(node.getId());
            }
            return this.delegate.calculateStats(node, sourceStats, lookup, session, types);
        }

        public void setNodeStats(PlanNodeId nodeId, PlanNodeStatsEstimate nodeStats) {
            this.stats.put(nodeId, nodeStats);
        }
    }

    private static class RuleApplication {
        private final Lookup lookup;
        private final StatsProvider statsProvider;
        private final TypeProvider types;
        private final Rule.Result result;

        public RuleApplication(Lookup lookup, StatsProvider statsProvider, TypeProvider types, Rule.Result result) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
            this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.result = Objects.requireNonNull(result, "result is null");
        }

        private boolean wasRuleApplied() {
            return !this.result.isEmpty();
        }

        public PlanNode getTransformedPlan() {
            return (PlanNode)this.result.getTransformedPlan().orElseThrow(() -> new IllegalStateException("Rule did not produce transformed plan"));
        }
    }
}

