/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule.test;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RuleTester
implements Closeable {
    public static final String CATALOG_ID = "local";
    public static final ConnectorId CONNECTOR_ID = new ConnectorId("local");
    private final Metadata metadata;
    private final Session session;
    private final LocalQueryRunner queryRunner;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;

    public RuleTester() {
        this(Collections.emptyList());
    }

    public RuleTester(List<Plugin> plugins) {
        this(plugins, (Map<String, String>)ImmutableMap.of());
    }

    public RuleTester(List<Plugin> plugins, Map<String, String> sessionProperties) {
        this(plugins, sessionProperties, Optional.empty());
    }

    public RuleTester(List<Plugin> plugins, Map<String, String> sessionProperties, Optional<Integer> nodeCountForStats) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog(CATALOG_ID).setSchema("tiny").setSystemProperty("task_concurrency", "1");
        for (Map.Entry<String, String> entry : sessionProperties.entrySet()) {
            sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
        }
        this.session = sessionBuilder.build();
        this.queryRunner = nodeCountForStats.map(nodeCount -> LocalQueryRunner.queryRunnerWithFakeNodeCountForStats((Session)this.session, (int)nodeCount)).orElseGet(() -> new LocalQueryRunner(this.session));
        this.queryRunner.createCatalog((String)this.session.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        plugins.stream().forEach(arg_0 -> ((LocalQueryRunner)this.queryRunner).installPlugin(arg_0));
        this.metadata = this.queryRunner.getMetadata();
        this.transactionManager = this.queryRunner.getTransactionManager();
        this.accessControl = this.queryRunner.getAccessControl();
    }

    public RuleAssert assertThat(Rule rule) {
        return new RuleAssert(this.metadata, this.queryRunner.getStatsCalculator(), this.queryRunner.getEstimatedExchangesCostCalculator(), this.session, rule, this.transactionManager, this.accessControl);
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public ConnectorId getCurrentConnectorId() {
        return (ConnectorId)((Optional)this.queryRunner.inTransaction(transactionSession -> this.metadata.getCatalogHandle(transactionSession, (String)this.session.getCatalog().get()))).get();
    }
}

