/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.ConstantProperty;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.AddExchanges;
import com.facebook.presto.sql.planner.optimizations.PreferredProperties;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAddExchanges {
    @Test
    public void testPickLayoutAnyPreference() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.any());
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a", "b")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)input);
    }

    @Test
    public void testPickLayoutPartitionedPreference() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.distributed());
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    @Test
    public void testPickLayoutUnpartitionedPreference() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.undistributed());
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    @Test
    public void testPickLayoutPartitionedOnSingle() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.partitioned((Set)ImmutableSet.of((Object)TestAddExchanges.symbol("a"))));
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    @Test
    public void testPickLayoutPartitionedOnMultiple() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.partitioned((Set)ImmutableSet.of((Object)TestAddExchanges.symbol("a"), (Object)TestAddExchanges.symbol("b"))));
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    @Test
    public void testPickLayoutGrouped() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.local((List)ImmutableList.of(TestAddExchanges.grouped("a"))));
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    @Test
    public void testPickLayoutGroupedMultiple() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))));
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    @Test
    public void testPickLayoutGroupedMultipleProperties() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.local((List)ImmutableList.of(TestAddExchanges.grouped("a"), TestAddExchanges.grouped("b"))));
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    @Test
    public void testPickLayoutGroupedWithSort() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.local((List)ImmutableList.of(TestAddExchanges.grouped("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))));
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    @Test
    public void testPickLayoutUnpartitionedWithGroupAndSort() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.undistributedWithLocal((List)ImmutableList.of(TestAddExchanges.grouped("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))));
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    @Test
    public void testPickLayoutPartitionedWithGroup() {
        Comparator preference = AddExchanges.streamingExecutionPreference((PreferredProperties)PreferredProperties.partitionedWithLocal((Set)ImmutableSet.of((Object)TestAddExchanges.symbol("a")), (List)ImmutableList.of(TestAddExchanges.grouped("a"))));
        ImmutableList input = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).build();
        ImmutableList expected = ImmutableList.builder().add((Object)ActualProperties.builder().global(TestAddExchanges.singleStream()).local((List)ImmutableList.of(TestAddExchanges.constant("a"), TestAddExchanges.sorted("b", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).local((List)ImmutableList.of(TestAddExchanges.sorted("a", SortOrder.ASC_NULLS_FIRST))).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.streamPartitionedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(TestAddExchanges.hashDistributedOn("a")).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).local((List)ImmutableList.of(TestAddExchanges.grouped("a", "b"))).build()).add((Object)ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build()).build();
        Assert.assertEquals(TestAddExchanges.stableSort(input, preference), (Collection)expected);
    }

    private static <T> List<T> stableSort(List<T> list, Comparator<T> comparator) {
        ArrayList copy = Lists.newArrayList(list);
        Collections.sort(copy, comparator);
        return copy;
    }

    private static ActualProperties.Global hashDistributedOn(String ... columnNames) {
        return ActualProperties.Global.partitionedOn((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, TestAddExchanges.arguments(columnNames), Optional.of(TestAddExchanges.arguments(columnNames)));
    }

    public static ActualProperties.Global singleStream() {
        return ActualProperties.Global.streamPartitionedOn((List)ImmutableList.of());
    }

    private static ActualProperties.Global streamPartitionedOn(String ... columnNames) {
        return ActualProperties.Global.streamPartitionedOn(TestAddExchanges.arguments(columnNames));
    }

    private static ConstantProperty<Symbol> constant(String column) {
        return new ConstantProperty((Object)TestAddExchanges.symbol(column));
    }

    private static GroupingProperty<Symbol> grouped(String ... columns) {
        return new GroupingProperty((Collection)Lists.transform(Arrays.asList(columns), Symbol::new));
    }

    private static SortingProperty<Symbol> sorted(String column, SortOrder order) {
        return new SortingProperty((Object)TestAddExchanges.symbol(column), order);
    }

    private static Symbol symbol(String name) {
        return new Symbol(name);
    }

    private static List<Symbol> arguments(String[] columnNames) {
        return (List)Arrays.asList(columnNames).stream().map(Symbol::new).collect(ImmutableList.toImmutableList());
    }
}

