/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.AddExchanges;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestEliminateSorts
extends BasePlanTest {
    private static final String QUANTITY_ALIAS = "QUANTITY";
    private static final ExpectedValueProvider<WindowNode.Specification> windowSpec = PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"QUANTITY"), (Map<String, SortOrder>)ImmutableMap.of((Object)"QUANTITY", (Object)SortOrder.ASC_NULLS_LAST));
    private static final PlanMatchPattern LINEITEM_TABLESCAN_Q = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity"));

    @Test
    public void testEliminateSorts() {
        String sql = "SELECT quantity, row_number() OVER (ORDER BY quantity) FROM lineitem ORDER BY quantity";
        PlanMatchPattern pattern = PlanMatchPattern.output(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowSpec).addFunction(PlanMatchPattern.functionCall("row_number", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_Q)));
        this.assertUnitPlan(sql, pattern);
    }

    @Test
    public void testNotEliminateSorts() {
        String sql = "SELECT quantity, row_number() OVER (ORDER BY quantity) FROM lineitem ORDER BY tax";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort(PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowSpec).addFunction(PlanMatchPattern.functionCall("row_number", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_Q)))));
        this.assertUnitPlan(sql, pattern);
    }

    public void assertUnitPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(), (Object)new AddExchanges(this.getQueryRunner().getMetadata(), new SqlParser()), (Object)new PruneUnreferencedOutputs(), (Object)new IterativeOptimizer(new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())));
        this.assertPlan(sql, pattern, (List<PlanOptimizer>)optimizers);
    }
}

